/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.logging.AbstractHandlerAdd;
import org.jboss.as.logging.AbstractHandlerElement;
import org.jboss.as.logging.AsyncHandlerAdd;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.OverflowAction;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class AsyncHandlerElement
extends AbstractHandlerElement<AsyncHandlerElement> {
    private static final long serialVersionUID = 6954036272784574253L;
    private static final QName ELEMENT_NAME = new QName(Namespace.CURRENT.getUriString(), Element.ASYNC_HANDLER.getLocalName());
    private int queueLength = 512;
    private OverflowAction overflowAction = OverflowAction.BLOCK;

    protected AsyncHandlerElement(String name) {
        super(name, ELEMENT_NAME);
    }

    protected Class<AsyncHandlerElement> getElementClass() {
        return AsyncHandlerElement.class;
    }

    void setQueueLength(int queueLength) {
        this.queueLength = queueLength;
    }

    void setOverflowAction(OverflowAction overflowAction) {
        this.overflowAction = overflowAction;
    }

    @Override
    protected void writeElements(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeEmptyElement(Element.QUEUE_LENGTH.getLocalName());
        streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), Integer.toString(this.queueLength));
        streamWriter.writeEmptyElement(Element.OVERFLOW_ACTION.getLocalName());
        streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), this.overflowAction.name().toLowerCase(Locale.US));
        super.writeElements(streamWriter);
    }

    @Override
    AbstractHandlerAdd createAdd(String name) {
        AsyncHandlerAdd add = new AsyncHandlerAdd(name);
        add.setOverflowAction(this.overflowAction);
        add.setQueueLength(this.queueLength);
        return add;
    }
}

