/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.jboss.as.logging.AbstractHandlerAdd;
import org.jboss.as.logging.AbstractHandlerElement;
import org.jboss.as.logging.FileHandlerElement;
import org.jboss.as.logging.FileHandlerService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.services.path.AbstractPathService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class FileHandlerAdd
extends AbstractHandlerAdd {
    private static final long serialVersionUID = 3144252544518106859L;
    private String relativeTo;
    private String path;
    private boolean append = true;

    protected FileHandlerAdd(String name) {
        super(name);
    }

    @Override
    protected AbstractHandlerElement<?> createElement(String name) {
        FileHandlerElement element = new FileHandlerElement(name);
        element.setPath(this.relativeTo, this.path);
        return element;
    }

    public String getRelativeTo() {
        return this.relativeTo;
    }

    public void setRelativeTo(String relativeTo) {
        this.relativeTo = relativeTo;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> handler, P param) {
        try {
            BatchBuilder batchBuilder = updateContext.getBatchBuilder();
            FileHandlerService service = new FileHandlerService();
            BatchServiceBuilder serviceBuilder = batchBuilder.addService(LogServices.handlerName(this.getName()), (Service)service);
            String relativeTo = this.relativeTo;
            if (relativeTo != null) {
                serviceBuilder.addDependency(AbstractPathService.pathNameOf((String)relativeTo), String.class, service.getRelativeToInjector());
            }
            service.setLevel(Level.parse(this.getLevelName()));
            Boolean autoFlush = this.getAutoflush();
            if (autoFlush != null) {
                service.setAutoflush(autoFlush);
            }
            try {
                service.setEncoding(this.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                handler.handleFailure((Throwable)e, param);
                return;
            }
            try {
                service.setPath(this.path);
            }
            catch (FileNotFoundException e) {
                handler.handleFailure((Throwable)e, param);
                return;
            }
            service.setFormatterSpec(this.getFormatter());
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            serviceBuilder.addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(handler, param));
        }
        catch (Throwable t) {
            handler.handleFailure(t, param);
            return;
        }
    }
}

