/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Level;
import org.jboss.as.logging.AbstractHandlerElement;
import org.jboss.as.logging.FileHandlerAdd;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.PeriodicRotatingFileHandlerElement;
import org.jboss.as.logging.PeriodicRotatingFileHandlerService;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.services.path.AbstractPathService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class PeriodicRotatingFileHandlerAdd
extends FileHandlerAdd {
    private static final long serialVersionUID = 3144252544518106859L;
    private String suffix;

    public PeriodicRotatingFileHandlerAdd(String name) {
        super(name);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    protected AbstractHandlerElement<?> createElement(String name) {
        PeriodicRotatingFileHandlerElement element = new PeriodicRotatingFileHandlerElement(name);
        element.setSuffix(this.suffix);
        element.setPath(this.getRelativeTo(), this.getPath());
        return element;
    }

    @Override
    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> handler, P param) {
        try {
            BatchBuilder batchBuilder = updateContext.getBatchBuilder();
            PeriodicRotatingFileHandlerService service = new PeriodicRotatingFileHandlerService();
            BatchServiceBuilder serviceBuilder = batchBuilder.addService(LogServices.handlerName(this.getName()), (Service)service);
            String relativeTo = this.getRelativeTo();
            if (relativeTo != null) {
                serviceBuilder.addDependency(AbstractPathService.pathNameOf((String)relativeTo), String.class, service.getRelativeToInjector());
            }
            service.setLevel(Level.parse(this.getLevelName()));
            Boolean autoFlush = this.getAutoflush();
            if (autoFlush != null) {
                service.setAutoflush(autoFlush);
            }
            service.setEncoding(this.getEncoding());
            service.setPath(this.getPath());
            service.setFormatterSpec(this.getFormatter());
            service.setSuffix(this.suffix);
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            serviceBuilder.addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(handler, param));
        }
        catch (Throwable t) {
            handler.handleFailure(t, param);
        }
    }
}

