/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.felix;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.FragmentRequirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.Wire;
import org.jboss.osgi.resolver.XBundleCapability;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XFragmentHostRequirement;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XWire;
import org.jboss.osgi.resolver.felix.FelixResolver;
import org.jboss.osgi.resolver.felix.ModuleExt;
import org.jboss.osgi.resolver.spi.AbstractModule;
import org.jboss.osgi.resolver.spi.AbstractPackageRequirement;

public class ResultProcessor {
    private FelixResolver resolver;

    ResultProcessor(FelixResolver resolver) {
        this.resolver = resolver;
    }

    public void setModuleWires(ModuleExt moduleExt, List<Wire> fwires) {
        moduleExt.setWires(fwires);
        ArrayList<XWire> result = new ArrayList<XWire>();
        AbstractModule module = moduleExt.getModule();
        for (XRequirement req : module.getRequirements()) {
            AbstractModule importer = (AbstractModule)req.getModule();
            Requirement freq = (Requirement)req.getAttachment(Requirement.class);
            if (freq == null) {
                throw new IllegalStateException("Cannot obtain felix requirement from: " + req);
            }
            Wire fwire = this.findWireForRequirement(fwires, freq);
            if (fwire == null) {
                this.handleNullWire(result, req);
                continue;
            }
            Capability fcap = fwire.getCapability();
            ModuleExt fexporter = (ModuleExt)fwire.getExporter();
            AbstractModule exporter = fexporter.getModule();
            XCapability cap = this.findCapability(fexporter, fcap);
            this.resolver.addWire(importer, req, (XModule)exporter, cap);
        }
    }

    private void handleNullWire(List<XWire> result, XRequirement req) {
        XWire wire = null;
        if (req instanceof XPackageRequirement) {
            AbstractModule importer = (AbstractModule)req.getModule();
            XPackageCapability cap = this.getMatchingPackageCapability((XModule)importer, req);
            if (cap == null && importer.isFragment()) {
                Requirement freq = (Requirement)req.getAttachment(Requirement.class);
                XModule host = this.getFragmentHost((XModule)importer);
                ModuleExt hostExt = (ModuleExt)host.getAttachment(ModuleExt.class);
                Wire fwire = this.findWireForRequirement(hostExt.getWires(), freq);
                if (fwire != null) {
                    cap = (XPackageCapability)this.findCapability((ModuleExt)fwire.getExporter(), fwire.getCapability());
                }
            }
            if (cap != null) {
                XModule exporter = cap.getModule();
                wire = this.resolver.addWire(importer, req, exporter, (XCapability)cap);
            }
        } else if (req instanceof XFragmentHostRequirement) {
            AbstractModule fragModule = (AbstractModule)req.getModule();
            XModule hostModule = this.getFragmentHost((XModule)fragModule);
            XBundleCapability hostCap = hostModule.getBundleCapability();
            wire = this.resolver.addWire(fragModule, req, hostModule, (XCapability)hostCap);
        }
        if (wire == null && !req.isOptional()) {
            throw new IllegalStateException("Cannot find a wire for mandatory requirement: " + req);
        }
    }

    private XPackageCapability getMatchingPackageCapability(XModule module, XRequirement req) {
        for (XPackageCapability cap : module.getPackageCapabilities()) {
            if (!((AbstractPackageRequirement)req).match(cap)) continue;
            return cap;
        }
        return null;
    }

    private XModule getFragmentHost(XModule fragModule) {
        ModuleExt ffrag = (ModuleExt)fragModule.getAttachment(ModuleExt.class);
        ModuleExt fHost = this.resolver.findHost(ffrag);
        AbstractModule hostModule = fHost.getModule();
        return hostModule;
    }

    public void setResolved(ModuleExt moduleExt) {
        moduleExt.setResolved();
        this.resolver.setResolved(moduleExt.getModule());
    }

    private Wire findWireForRequirement(List<Wire> fwires, Requirement freq) {
        Wire fwire = null;
        if (fwires != null) {
            for (Wire aux : fwires) {
                Requirement auxreq = aux.getRequirement();
                if (auxreq == freq) {
                    fwire = aux;
                    break;
                }
                if (!(auxreq instanceof FragmentRequirement) || (auxreq = ((FragmentRequirement)auxreq).getRequirement()) != freq) continue;
                fwire = aux;
                break;
            }
        }
        return fwire;
    }

    private XCapability findCapability(ModuleExt fexporter, Capability fcap) {
        String capNamespace = fcap.getNamespace();
        Attribute capValue = fcap.getAttribute(capNamespace);
        AbstractModule exporter = fexporter.getModule();
        for (XCapability aux : exporter.getCapabilities()) {
            Capability auxfcap = (Capability)aux.getAttachment(Capability.class);
            if (auxfcap != fcap) continue;
            return aux;
        }
        for (Module fFragment : fexporter.getFragments()) {
            exporter = ((ModuleExt)fFragment).getModule();
            for (XCapability aux : exporter.getCapabilities()) {
                Capability faux = (Capability)aux.getAttachment(Capability.class);
                String auxNamespace = faux.getNamespace();
                Attribute auxValue = faux.getAttribute(auxNamespace);
                boolean match = capNamespace.equals(auxNamespace);
                match = match && capValue != null && capValue.equals(auxValue);
                if (!match) continue;
                return aux;
            }
        }
        return null;
    }
}

