/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver;

import org.osgi.framework.Version;

public class XVersionRange {
    private final Version m_floor;
    private final boolean m_isFloorInclusive;
    private final Version m_ceiling;
    private final boolean m_isCeilingInclusive;
    public static final XVersionRange infiniteRange = new XVersionRange(Version.emptyVersion, true, null, true);

    public XVersionRange(Version low, boolean isLowInclusive, Version high, boolean isHighInclusive) {
        this.m_floor = low;
        this.m_isFloorInclusive = isLowInclusive;
        this.m_ceiling = high;
        this.m_isCeilingInclusive = isHighInclusive;
    }

    public Version getFloor() {
        return this.m_floor;
    }

    public boolean isFloorInclusive() {
        return this.m_isFloorInclusive;
    }

    public Version getCeiling() {
        return this.m_ceiling;
    }

    public boolean isCeilingInclusive() {
        return this.m_isCeilingInclusive;
    }

    public boolean isInRange(Version version) {
        if (this.m_ceiling == null) {
            return version.compareTo((Object)this.m_floor) >= 0;
        }
        if (this.isFloorInclusive() && this.isCeilingInclusive()) {
            return version.compareTo((Object)this.m_floor) >= 0 && version.compareTo((Object)this.m_ceiling) <= 0;
        }
        if (this.isCeilingInclusive()) {
            return version.compareTo((Object)this.m_floor) > 0 && version.compareTo((Object)this.m_ceiling) <= 0;
        }
        if (this.isFloorInclusive()) {
            return version.compareTo((Object)this.m_floor) >= 0 && version.compareTo((Object)this.m_ceiling) < 0;
        }
        return version.compareTo((Object)this.m_floor) > 0 && version.compareTo((Object)this.m_ceiling) < 0;
    }

    public static XVersionRange parse(String range) {
        if (range.indexOf(44) >= 0) {
            String s = range.substring(1, range.length() - 1);
            String vlo = s.substring(0, s.indexOf(44)).trim();
            String vhi = s.substring(s.indexOf(44) + 1, s.length()).trim();
            return new XVersionRange(new Version(vlo), range.charAt(0) == '[', new Version(vhi), range.charAt(range.length() - 1) == ']');
        }
        return new XVersionRange(new Version(range), true, null, false);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XVersionRange other = (XVersionRange)obj;
        if (!(this.m_floor == other.m_floor || this.m_floor != null && this.m_floor.equals((Object)other.m_floor))) {
            return false;
        }
        if (this.m_isFloorInclusive != other.m_isFloorInclusive) {
            return false;
        }
        if (!(this.m_ceiling == other.m_ceiling || this.m_ceiling != null && this.m_ceiling.equals((Object)other.m_ceiling))) {
            return false;
        }
        return this.m_isCeilingInclusive == other.m_isCeilingInclusive;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.m_floor != null ? this.m_floor.hashCode() : 0);
        hash = 97 * hash + (this.m_isFloorInclusive ? 1 : 0);
        hash = 97 * hash + (this.m_ceiling != null ? this.m_ceiling.hashCode() : 0);
        hash = 97 * hash + (this.m_isCeilingInclusive ? 1 : 0);
        return hash;
    }

    public String toString() {
        if (this.m_ceiling != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_isFloorInclusive ? (char)'[' : '(');
            sb.append(this.m_floor.toString());
            sb.append(',');
            sb.append(this.m_ceiling.toString());
            sb.append(this.m_isCeilingInclusive ? (char)']' : ')');
            return sb.toString();
        }
        return this.m_floor.toString();
    }
}

