/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import javax.xml.stream.XMLStreamException;
import org.jboss.as.threads.AbstractExecutorElement;
import org.jboss.as.threads.QueuelessThreadPoolAdd;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class QueuelessThreadPoolElement
extends AbstractExecutorElement<QueuelessThreadPoolElement> {
    private static final long serialVersionUID = -8281883758711778557L;
    private String handoffExecutor;
    private boolean blocking;

    public QueuelessThreadPoolElement(String name) {
        super(name);
    }

    protected Class<QueuelessThreadPoolElement> getElementClass() {
        return QueuelessThreadPoolElement.class;
    }

    public String getHandoffExecutor() {
        return this.handoffExecutor;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    void setHandoffExecutor(String handoffExecutor) {
        this.handoffExecutor = handoffExecutor;
    }

    void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    @Override
    protected void writeAttributes(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        super.writeAttributes(streamWriter);
        streamWriter.writeAttribute("blocking", Boolean.toString(this.blocking));
    }

    @Override
    protected void writeElements(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        super.writeElements(streamWriter);
        if (this.handoffExecutor != null) {
            streamWriter.writeEmptyElement("handoff-executor");
            streamWriter.writeAttribute("name", this.handoffExecutor);
        }
    }

    QueuelessThreadPoolAdd getAdd() {
        QueuelessThreadPoolAdd add = new QueuelessThreadPoolAdd(this.getName(), this.getMaxThreads());
        add.setBlocking(this.isBlocking());
        add.setHandoffExecutor(this.getHandoffExecutor());
        add.setKeepaliveTime(this.getKeepaliveTime());
        add.setThreadFactory(this.getThreadFactory());
        add.getProperties().putAll(this.getProperties());
        return add;
    }
}

