/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.server.manager.DomainControllerConnection;
import org.jboss.as.server.manager.RemoteDomainControllerConnection;
import org.jboss.as.server.manager.ServerManager;
import org.jboss.as.services.net.NetworkInterfaceBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DomainControllerConnectionService
implements Service<DomainControllerConnection> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"domain", "controller", "client"});
    private final InjectedValue<InetAddress> domainControllerAddress = new InjectedValue();
    private final InjectedValue<Integer> domainControllerPort = new InjectedValue();
    private final InjectedValue<NetworkInterfaceBinding> localManagementInterface = new InjectedValue();
    private final InjectedValue<Integer> localManagementPort = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> executorService = new InjectedValue();
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private final ServerManager serverManager;
    private final FileRepository localRepository;
    private final long connectTimeout;
    private DomainControllerConnection domainControllerConnection;

    public DomainControllerConnectionService(ServerManager serverManager, FileRepository localRepository, long connectTimeout) {
        this.serverManager = serverManager;
        this.localRepository = localRepository;
        this.connectTimeout = connectTimeout;
    }

    public synchronized void start(StartContext context) throws StartException {
        InetAddress dcAddress = (InetAddress)this.domainControllerAddress.getValue();
        if (dcAddress.isAnyLocalAddress() || dcAddress.isSiteLocalAddress()) {
            try {
                dcAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new StartException("Failed to get domain controller address", (Throwable)e);
            }
        }
        NetworkInterfaceBinding managementInterface = (NetworkInterfaceBinding)this.localManagementInterface.getValue();
        this.domainControllerConnection = new RemoteDomainControllerConnection(this.serverManager.getName(), dcAddress, (Integer)this.domainControllerPort.getValue(), managementInterface.getAddress(), (Integer)this.localManagementPort.getValue(), this.localRepository, this.connectTimeout, (ScheduledExecutorService)this.executorService.getValue(), (ThreadFactory)this.threadFactoryValue.getValue());
    }

    public synchronized void stop(StopContext context) {
        this.domainControllerConnection = null;
    }

    public DomainControllerConnection getValue() throws IllegalStateException {
        return this.domainControllerConnection;
    }

    public Injector<InetAddress> getDomainControllerAddressInjector() {
        return this.domainControllerAddress;
    }

    public Injector<Integer> getDomainControllerPortInjector() {
        return this.domainControllerPort;
    }

    public Injector<NetworkInterfaceBinding> getLocalManagementInterfaceInjector() {
        return this.localManagementInterface;
    }

    public Injector<Integer> getLocalManagementPortInjector() {
        return this.localManagementPort;
    }

    public Injector<ScheduledExecutorService> getExecutorServiceInjector() {
        return this.executorService;
    }

    public Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }
}

