/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.manager.ServerManager;
import org.jboss.as.server.manager.ServerManagerEnvironment;
import org.jboss.as.server.manager.SystemExiter;
import org.jboss.as.version.Version;
import org.jboss.logging.MDC;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;

public final class Main {
    Properties props = new Properties(System.getProperties());

    public static String getVersionString() {
        return Version.AS_VERSION;
    }

    private static void usage() {
        System.out.println("Usage: ./domain.sh [args...]\n");
        System.out.println("where args include:");
        System.out.println("    -D<name>[=<value>]                 Set a system property");
        System.out.println("    -help                              Display this message and exit");
        System.out.println("    -pm-address <address>              Address of process manager socket");
        System.out.println("    -pm-port <port>                    Port of process manager socket");
        System.out.println("    -interprocess-name <proc>          Name of this process, used to register the socket with the server in the process manager");
        System.out.println("    -interprocess-sm-address <address> Address this server manager's socket should listen on");
        System.out.println("    -interprocess-sm-port <port>       Port of this server manager's socket  should listen on");
        System.out.println("    -P  <url>                          Load system properties from the given url");
        System.out.println("    -properties <url>                  Load system properties from the given url");
        System.out.println("    -version                           Print version and exit\n");
    }

    public static void main(String[] args) throws IOException {
        MDC.put((String)"process", (Object)"server manager");
        InputStream in = System.in;
        PrintStream out = System.out;
        PrintStream err = System.err;
        byte[] authKey = new byte[16];
        try {
            StreamUtils.readFully((InputStream)System.in, (byte[])authKey);
        }
        catch (IOException e) {
            System.err.printf("Failed to read authentication key: %s", e);
            System.exit(1);
            return;
        }
        StdioContext.install();
        StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (java.util.logging.Level)Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (java.util.logging.Level)Level.ERROR));
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        Main.create(args, in, out, err, authKey);
        while (in.read() != -1) {
        }
        System.exit(0);
    }

    private Main() {
    }

    private static ServerManager create(String[] args, InputStream stdin, PrintStream stdout, PrintStream stderr, byte[] authCode) {
        Main main = new Main();
        return main.boot(args, stdin, stdout, stderr, authCode);
    }

    private ServerManager boot(String[] args, InputStream stdin, PrintStream stdout, PrintStream stderr, byte[] authCode) {
        ServerManager sm = null;
        try {
            ServerManagerEnvironment config = Main.determineEnvironment(args, this.props, stdin, stdout, stderr);
            if (config == null) {
                this.abort(null);
                return null;
            }
            sm = new ServerManager(config, authCode);
            sm.start();
        }
        catch (Throwable t) {
            t.printStackTrace(stderr);
            this.abort(t);
            return null;
        }
        return sm;
    }

    private void abort(Throwable t) {
        try {
            t.printStackTrace();
            throw new UnsupportedOperationException("implement me");
        }
        catch (Throwable throwable) {
            SystemExiter.exit(1);
            throw throwable;
        }
    }

    public static ServerManagerEnvironment determineEnvironment(String[] args, Properties systemProperties, InputStream stdin, PrintStream stdout, PrintStream stderr) {
        Integer pmPort = null;
        InetAddress pmAddress = null;
        Integer smPort = 0;
        InetAddress smAddress = null;
        try {
            smAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        String procName = "Server Manager";
        String defaultJVM = null;
        boolean isRestart = false;
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                if ("-version".equals(arg)) {
                    System.out.println("JBoss Application Server " + Main.getVersionString());
                    return null;
                }
                if ("-help".equals(arg)) {
                    Main.usage();
                    return null;
                }
                if ("-properties".equals(arg) || "-P".equals(arg)) {
                    URL url = null;
                    try {
                        url = Main.makeURL(args[++i]);
                        Properties props = System.getProperties();
                        props.load(url.openConnection().getInputStream());
                        continue;
                    }
                    catch (MalformedURLException e) {
                        System.err.printf("Malformed URL provided for option %s\n", arg);
                        Main.usage();
                        return null;
                    }
                    catch (IOException e) {
                        System.err.printf("Unable to load properties from URL %s\n", url);
                        Main.usage();
                        return null;
                    }
                }
                if ("-pm-port".equals(arg)) {
                    try {
                        pmPort = Integer.valueOf(args[++i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.err.printf("Value for %s is not an Integer -- %s\n", "-pm-port", args[i]);
                        Main.usage();
                        return null;
                    }
                }
                if ("-pm-address".equals(arg)) {
                    try {
                        pmAddress = InetAddress.getByName(args[++i]);
                        continue;
                    }
                    catch (UnknownHostException e) {
                        System.err.printf("Value for %s is not a known host -- %s\n", "-pm-address", args[i]);
                        Main.usage();
                        return null;
                    }
                }
                if ("-interprocess-sm-port".equals(arg)) {
                    try {
                        smPort = Integer.valueOf(args[++i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.err.printf("Value for %s is not an Integer -- %s\n", "-interprocess-sm-port", args[i]);
                        Main.usage();
                        return null;
                    }
                }
                if ("-interprocess-sm-address".equals(arg)) {
                    try {
                        smAddress = InetAddress.getByName(args[++i]);
                        continue;
                    }
                    catch (UnknownHostException e) {
                        System.err.printf("Value for %s is not a known host -- %s\n", "-interprocess-sm-address", args[i]);
                        Main.usage();
                        return null;
                    }
                }
                if ("-interprocess-name".equals(arg)) {
                    procName = args[++i];
                    continue;
                }
                if ("-restarted-server-manager".equals(arg)) {
                    isRestart = true;
                    continue;
                }
                if ("-default-jvm".equals(arg)) {
                    defaultJVM = args[++i];
                    continue;
                }
                if (arg.startsWith("-D")) {
                    String value;
                    String name;
                    int idx = arg.indexOf("=");
                    if (idx == -1) {
                        name = arg.substring(2);
                        value = "true";
                    } else {
                        name = arg.substring(2, idx);
                        value = arg.substring(idx + 1, arg.length());
                    }
                    System.setProperty(name, value);
                    continue;
                }
                System.err.printf("Invalid option '%s'\n", arg);
                Main.usage();
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf("Argument expected for option %s\n", arg);
                Main.usage();
                return null;
            }
        }
        return new ServerManagerEnvironment(systemProperties, isRestart, stdin, stdout, stderr, procName, pmAddress, pmPort, smAddress, smPort, defaultJVM);
    }

    private static URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURI().toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURI().toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }
}

