/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.jboss.as.domain.client.api.HostUpdateResult;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.ServerStatus;
import org.jboss.as.domain.client.impl.HostUpdateApplierResponse;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.mgmt.DomainControllerClientOperationHandler;
import org.jboss.as.domain.controller.mgmt.DomainControllerOperationHandler;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ManagementElement;
import org.jboss.as.model.RemoteDomainControllerElement;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandlerResponse;
import org.jboss.as.model.socket.InterfaceElement;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.process.ProcessManagerClient;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.protocol.ProtocolClient;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.server.ServerState;
import org.jboss.as.server.manager.DomainControllerConnection;
import org.jboss.as.server.manager.DomainControllerConnectionService;
import org.jboss.as.server.manager.FallbackRepository;
import org.jboss.as.server.manager.LocalDomainControllerConnection;
import org.jboss.as.server.manager.LocalFileRepository;
import org.jboss.as.server.manager.ManagedServer;
import org.jboss.as.server.manager.ModelManager;
import org.jboss.as.server.manager.ServerManagerEnvironment;
import org.jboss.as.server.manager.ServerManagerService;
import org.jboss.as.server.manager.StandardElementReaderRegistrar;
import org.jboss.as.server.manager.mgmt.ManagementCommunicationService;
import org.jboss.as.server.manager.mgmt.ManagementCommunicationServiceInjector;
import org.jboss.as.server.manager.mgmt.ManagementOperationHandlerService;
import org.jboss.as.server.manager.mgmt.ServerManagerOperationHandler;
import org.jboss.as.server.manager.mgmt.ServerToServerManagerOperationHandler;
import org.jboss.as.services.net.NetworkInterfaceBinding;
import org.jboss.as.services.net.NetworkInterfaceService;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceActivatorContextImpl;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.staxmapper.XMLMapper;

public class ServerManager {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.manager");
    static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"server", "manager"});
    private final ServerManagerEnvironment environment;
    private final StandardElementReaderRegistrar extensionRegistrar;
    private final FileRepository fileRepository;
    private final ModelManager modelManager;
    private final ServiceContainer serviceContainer = ServiceContainer.Factory.create();
    private final AtomicBoolean serversStarted = new AtomicBoolean();
    private final AtomicBoolean stopping = new AtomicBoolean();
    private final Map<String, ManagedServer> servers = new HashMap<String, ManagedServer>();
    private DomainControllerConnection domainControllerConnection;
    private InetSocketAddress managementSocketAddress;
    private ProcessManagerClient processManagerClient;
    private FallbackRepository remoteBackedRepository;
    private final byte[] authCode;

    public ServerManager(ServerManagerEnvironment environment, byte[] authCode) {
        this.authCode = authCode;
        if (environment == null) {
            throw new IllegalArgumentException("bootstrapConfig is null");
        }
        this.environment = environment;
        this.extensionRegistrar = StandardElementReaderRegistrar.Factory.getRegistrar();
        this.modelManager = new ModelManager(environment, this.extensionRegistrar);
        this.fileRepository = new LocalFileRepository(environment);
    }

    public String getName() {
        return this.getHostModel().getName();
    }

    public Map<ServerIdentity, ServerStatus> getServerStatuses() {
        HashMap<ServerIdentity, ServerStatus> result = new HashMap<ServerIdentity, ServerStatus>();
        for (ServerElement se : this.getHostModel().getServers()) {
            ServerIdentity id = new ServerIdentity(this.getName(), se.getServerGroup(), se.getName());
            ServerStatus status = this.determineServerStatus(se);
            result.put(id, status);
        }
        return result;
    }

    private ServerStatus determineServerStatus(String serverName) {
        return this.determineServerStatus(this.getHostModel().getServer(serverName));
    }

    private ServerStatus determineServerStatus(ServerElement se) {
        ServerStatus status;
        if (se == null) {
            status = ServerStatus.DOES_NOT_EXIST;
        } else {
            ManagedServer client = this.servers.get(ManagedServer.getServerProcessName(se.getName()));
            if (client == null) {
                status = se.isStart() ? ServerStatus.STOPPED : ServerStatus.DISABLED;
            } else {
                switch (client.getState()) {
                    case AVAILABLE: 
                    case BOOTING: 
                    case STARTING: {
                        status = ServerStatus.STARTING;
                        break;
                    }
                    case FAILED: 
                    case MAX_FAILED: {
                        status = ServerStatus.FAILED;
                        break;
                    }
                    case STARTED: {
                        status = ServerStatus.STARTED;
                        break;
                    }
                    case STOPPING: {
                        status = ServerStatus.STOPPING;
                        break;
                    }
                    case STOPPED: {
                        status = ServerStatus.STOPPED;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected state " + client.getState());
                    }
                }
            }
        }
        return status;
    }

    public ServerModel getServerModel(String serverName) {
        ManagedServer client = this.servers.get(ManagedServer.getServerProcessName(serverName));
        if (client == null) {
            log.debugf("Received getServerModel request for unknown server %s", (Object)serverName);
            return null;
        }
        return client.getServerModel();
    }

    public void start() throws IOException {
        this.modelManager.start();
        this.launchProcessManagerSlave();
        BatchBuilder batchBuilder = this.serviceContainer.batchBuilder();
        batchBuilder.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void serviceFailed(ServiceController<?> serviceController, StartException reason) {
                log.errorf((Throwable)reason, "Service [%s] failed.", (Object)serviceController.getName());
            }
        });
        ServiceActivatorContextImpl serviceActivatorContext = new ServiceActivatorContextImpl(batchBuilder);
        this.activateManagementCommunication((ServiceActivatorContext)serviceActivatorContext);
        if (this.getHostModel().getLocalDomainControllerElement() != null) {
            this.activateLocalDomainController((ServiceActivatorContext)serviceActivatorContext);
        } else {
            this.activateRemoteDomainControllerConnection((ServiceActivatorContext)serviceActivatorContext);
        }
        ManagementElement managementElement = this.getHostModel().getManagementElement();
        ServerManagerService serverManagerService = new ServerManagerService(this);
        batchBuilder.addService(SERVICE_NAME_BASE, (Service)serverManagerService).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{managementElement.getInterfaceName()}), NetworkInterfaceBinding.class, serverManagerService.getManagementInterfaceInjector()).addInjection(serverManagerService.getManagementPortInjector(), (Object)managementElement.getPort()).addDependency(DomainControllerConnection.SERVICE_NAME, DomainControllerConnection.class, serverManagerService.getDomainControllerConnectionInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
        try {
            batchBuilder.install();
        }
        catch (ServiceRegistryException e) {
            throw new RuntimeException(e);
        }
    }

    public void connectionClosed(String processName) {
        if (this.stopping.get()) {
            return;
        }
        ManagedServer server = this.servers.get(processName);
        if (server == null) {
            log.errorf("No server called %s with a closed connection", (Object)processName);
            return;
        }
        ServerState state = server.getState();
        if (state == ServerState.STOPPED || state == ServerState.STOPPING || state == ServerState.MAX_FAILED) {
            log.debugf("Ignoring closed connection for server %s in the %s state", (Object)processName, (Object)state);
            return;
        }
    }

    public List<HostUpdateResult<?>> applyHostUpdates(List<AbstractHostModelUpdate<?>> updates) {
        List<HostUpdateApplierResponse> hostResults = this.getModelManager().applyHostModelUpdates(updates);
        boolean allowOverallRollback = true;
        return this.applyUpdatesToServers(updates, hostResults, allowOverallRollback);
    }

    public List<UpdateResultHandlerResponse<?>> applyUpdatesToServer(ServerIdentity server, List<AbstractServerModelUpdate<?>> updates, boolean allowOverallRollback) {
        ArrayList<UpdateResultHandlerResponse<?>> responses;
        ManagedServer client = this.servers.get(ManagedServer.getServerProcessName(server.getServerName()));
        if (client == null) {
            responses = new ArrayList();
            UpdateResultHandlerResponse failure = UpdateResultHandlerResponse.createFailureResponse((Throwable)new IllegalStateException("unknown host " + server.getHostName()));
            for (int i = 0; i < updates.size(); ++i) {
                responses.add(failure);
            }
        } else {
            responses = client.applyUpdates(updates, allowOverallRollback);
        }
        return responses;
    }

    public List<UpdateResultHandlerResponse<?>> applyServerUpdates(String serverName, List<AbstractServerModelUpdate<?>> updates, boolean allowOverallRollback) {
        ManagedServer server = this.servers.get(ManagedServer.getServerProcessName(serverName));
        if (server == null) {
            log.debugf("Cannot apply updates to unknown server %s", (Object)serverName);
            UpdateResultHandlerResponse urhr = UpdateResultHandlerResponse.createFailureResponse((Throwable)new UpdateFailedException("No server available with name " + serverName));
            int size = updates.size();
            ArrayList list = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                list.add(urhr);
            }
            return list;
        }
        return server.applyUpdates(updates, allowOverallRollback);
    }

    void availableServer(String serverName) {
        try {
            ManagedServer server = this.servers.get(serverName);
            if (server == null) {
                log.errorf("No server called %s available", (Object)serverName);
                return;
            }
            this.checkState(server, ServerState.BOOTING);
            server.setState(ServerState.AVAILABLE);
            log.infof("Sending config to server %s", (Object)serverName);
            server.startServerProcess();
            server.setState(ServerState.STARTING);
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Could not start server %s", (Object)serverName);
        }
    }

    public void stop() {
        if (this.stopping.getAndSet(true)) {
            return;
        }
        log.info((Object)"Stopping ServerManager");
        if (this.domainControllerConnection != null) {
            this.domainControllerConnection.unregister();
        }
        this.serviceContainer.shutdown();
    }

    void stoppedServer(String serverName) {
        if (this.stopping.get()) {
            return;
        }
        ManagedServer server = this.servers.get(serverName);
        if (server == null) {
            log.errorf("No server called %s exists for stop", (Object)serverName);
            return;
        }
        this.checkState(server, ServerState.STOPPING);
        try {
            this.processManagerClient.stopProcess(serverName);
        }
        catch (IOException e) {
            if (this.stopping.get()) {
                return;
            }
            log.errorf((Throwable)e, "Could not stop server %s in PM", (Object)serverName);
        }
        try {
            this.processManagerClient.removeProcess(serverName);
        }
        catch (IOException e) {
            if (this.stopping.get()) {
                return;
            }
            log.errorf((Throwable)e, "Could not stop server %s", (Object)serverName);
        }
    }

    void startedServer(String serverName) {
        ManagedServer server = this.servers.get(serverName);
        if (server == null) {
            log.errorf("No server called %s exists for start", (Object)serverName);
            return;
        }
        this.checkState(server, ServerState.STARTING);
        server.setState(ServerState.STARTED);
    }

    void failedStartServer(String serverName) {
        ManagedServer server = this.servers.get(serverName);
        if (server == null) {
            log.errorf("No server called %s exists", (Object)serverName);
            return;
        }
        this.checkState(server, ServerState.STARTING);
        server.setState(ServerState.FAILED);
    }

    void reconnectedServer(String serverName, ServerState state) {
        ManagedServer server = this.servers.get(serverName);
        if (server == null) {
            log.errorf("No server found for reconnected server %s", (Object)serverName);
            return;
        }
        server.setState(state);
        if (state.isRestartOnReconnect()) {
            try {
                server.startServerProcess();
            }
            catch (IOException e) {
                log.errorf((Throwable)e, "Could not start reconnected server %s", (Object)server.getServerProcessName());
            }
        }
    }

    public void downServer(String downServerName) {
        ManagedServer server = this.servers.get(downServerName);
        if (server == null) {
            log.errorf("No server called %s exists", (Object)downServerName);
            return;
        }
        if (this.environment.isRestart() && server.getState() == ServerState.BOOTING && this.environment.getServerManagerPort() == 0) {
            try {
                server.removeServerProcess();
                server.addServerProcess();
            }
            catch (IOException e) {
                log.errorf("Error removing and adding process %s", (Object)downServerName);
                return;
            }
            try {
                server.startServerProcess();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        server.setState(ServerState.FAILED);
    }

    private void launchProcessManagerSlave() throws IOException {
        ProtocolClient.Configuration configuration = new ProtocolClient.Configuration();
        configuration.setReadExecutor((Executor)Executors.newCachedThreadPool());
        configuration.setServerAddress(new InetSocketAddress(this.environment.getProcessManagerAddress(), (int)this.environment.getProcessManagerPort()));
        configuration.setThreadFactory(Executors.defaultThreadFactory());
        configuration.setSocketFactory(SocketFactory.getDefault());
        this.processManagerClient = ProcessManagerClient.connect((ProtocolClient.Configuration)configuration, (byte[])this.authCode, (ProcessMessageHandler)new ProcessMessageHandler(){

            public void handleProcessAdded(ProcessManagerClient client, String processName) {
            }

            public void handleProcessStarted(ProcessManagerClient client, String processName) {
            }

            public void handleProcessStopped(ProcessManagerClient client, String processName, long uptimeMillis) {
            }

            public void handleProcessRemoved(ProcessManagerClient client, String processName) {
            }

            public void handleProcessInventory(ProcessManagerClient client, Map<String, ProcessInfo> inventory) {
            }

            public void handleConnectionShutdown(ProcessManagerClient client) {
            }

            public void handleConnectionFailure(ProcessManagerClient client, IOException cause) {
            }

            public void handleConnectionFinished(ProcessManagerClient client) {
            }
        });
        this.processManagerClient.requestProcessInventory();
    }

    private void activateLocalDomainController(ServiceActivatorContext serviceActivatorContext) {
        try {
            BatchBuilder batchBuilder = serviceActivatorContext.getBatchBuilder();
            XMLMapper mapper = XMLMapper.Factory.create();
            this.extensionRegistrar.registerStandardDomainReaders(mapper);
            DomainController domainController = new DomainController();
            batchBuilder.addService(DomainController.SERVICE_NAME, (Service)domainController).addInjection(domainController.getXmlMapperInjector(), (Object)mapper).addInjection(domainController.getDomainConfigDirInjector(), (Object)this.environment.getDomainConfigurationDir()).addInjection(domainController.getDomainDeploymentsDirInjector(), (Object)this.environment.getDomainDeploymentDir()).addDependency(SERVICE_NAME_BASE.append(new String[]{"executor"}), ScheduledExecutorService.class, domainController.getScheduledExecutorServiceInjector());
            DomainControllerOperationHandler domainControllerOperationHandler = new DomainControllerOperationHandler();
            batchBuilder.addService(DomainControllerOperationHandler.SERVICE_NAME, (Service)domainControllerOperationHandler).addDependency(DomainController.SERVICE_NAME, DomainController.class, domainControllerOperationHandler.getDomainControllerInjector()).addDependency(SERVICE_NAME_BASE.append(new String[]{"executor"}), ScheduledExecutorService.class, domainControllerOperationHandler.getExecutorServiceInjector()).addDependency(SERVICE_NAME_BASE.append(new String[]{"thread-factory"}), ThreadFactory.class, domainControllerOperationHandler.getThreadFactoryInjector()).addInjection(domainControllerOperationHandler.getLocalFileRepositoryInjector(), (Object)this.fileRepository).addDependency(ManagementCommunicationService.SERVICE_NAME, ManagementCommunicationService.class, (Injector)new ManagementCommunicationServiceInjector((Value<? extends ManagementOperationHandler>)domainControllerOperationHandler));
            DomainControllerClientOperationHandler domainControllerClientOperationHandler = new DomainControllerClientOperationHandler();
            batchBuilder.addService(DomainControllerClientOperationHandler.SERVICE_NAME, (Service)domainControllerClientOperationHandler).addDependency(DomainController.SERVICE_NAME, DomainController.class, domainControllerClientOperationHandler.getDomainControllerInjector()).addDependency(ManagementCommunicationService.SERVICE_NAME, ManagementCommunicationService.class, (Injector)new ManagementCommunicationServiceInjector((Value<? extends ManagementOperationHandler>)domainControllerClientOperationHandler));
            batchBuilder.addService(DomainControllerConnection.SERVICE_NAME, (Service)new LocalDomainControllerConnection(this, domainController, this.fileRepository)).addDependency(DomainController.SERVICE_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception starting local domain controller", e);
        }
    }

    private void activateRemoteDomainControllerConnection(ServiceActivatorContext serviceActivatorContext) {
        InetAddress hostAddress;
        BatchBuilder batchBuilder = serviceActivatorContext.getBatchBuilder();
        DomainControllerConnectionService domainControllerClientService = new DomainControllerConnectionService(this, this.fileRepository, 10L);
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(DomainControllerConnectionService.SERVICE_NAME, (Service)domainControllerClientService).addListener((ServiceListener)new AbstractServiceListener<DomainControllerConnection>(){

            public void serviceFailed(ServiceController<? extends DomainControllerConnection> serviceController, StartException reason) {
                log.error((Object)"Failed to register with domain controller.", (Throwable)reason);
            }
        }).addAliases(new ServiceName[]{DomainControllerConnection.SERVICE_NAME}).setInitialMode(ServiceController.Mode.ACTIVE);
        HostModel hostConfig = this.getHostModel();
        RemoteDomainControllerElement remoteDomainControllerElement = hostConfig.getRemoteDomainControllerElement();
        try {
            hostAddress = InetAddress.getByName(remoteDomainControllerElement.getHost());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to get remote domain controller address", e);
        }
        serviceBuilder.addInjection(domainControllerClientService.getDomainControllerAddressInjector(), (Object)hostAddress);
        serviceBuilder.addInjection(domainControllerClientService.getDomainControllerPortInjector(), (Object)remoteDomainControllerElement.getPort());
        ManagementElement managementElement = hostConfig.getManagementElement();
        serviceBuilder.addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{managementElement.getInterfaceName()}), NetworkInterfaceBinding.class, domainControllerClientService.getLocalManagementInterfaceInjector());
        serviceBuilder.addInjection(domainControllerClientService.getLocalManagementPortInjector(), (Object)managementElement.getPort());
        serviceBuilder.addDependency(SERVICE_NAME_BASE.append(new String[]{"executor"}), ScheduledExecutorService.class, domainControllerClientService.getExecutorServiceInjector());
        serviceBuilder.addDependency(SERVICE_NAME_BASE.append(new String[]{"thread-factory"}), ThreadFactory.class, domainControllerClientService.getThreadFactoryInjector());
    }

    private void activateManagementCommunication(ServiceActivatorContext serviceActivatorContext) {
        BatchBuilder batchBuilder = serviceActivatorContext.getBatchBuilder();
        HostModel hostConfig = this.getHostModel();
        ManagementElement managementElement = hostConfig.getManagementElement();
        if (managementElement == null) {
            throw new IllegalStateException("null management configuration");
        }
        Set hostInterfaces = hostConfig.getInterfaces();
        if (hostInterfaces != null) {
            for (InterfaceElement interfaceElement : hostInterfaces) {
                if (!interfaceElement.getName().equals(managementElement.getInterfaceName())) continue;
                interfaceElement.activate(serviceActivatorContext);
                break;
            }
        }
        ServiceName threadFactoryServiceName = SERVICE_NAME_BASE.append(new String[]{"thread-factory"});
        batchBuilder.addService(threadFactoryServiceName, (Service)new ThreadFactoryService());
        ServiceName executorServiceName = SERVICE_NAME_BASE.append(new String[]{"executor"});
        final InjectedValue threadFactoryValue = new InjectedValue();
        batchBuilder.addService(executorServiceName, (Service)new Service<ScheduledExecutorService>(){
            private ScheduledExecutorService executorService;

            public synchronized void start(StartContext context) throws StartException {
                this.executorService = Executors.newScheduledThreadPool(20, (ThreadFactory)threadFactoryValue.getValue());
            }

            public synchronized void stop(StopContext context) {
                this.executorService.shutdown();
            }

            public synchronized ScheduledExecutorService getValue() throws IllegalStateException {
                return this.executorService;
            }
        }).addDependency(threadFactoryServiceName, ThreadFactory.class, (Injector)threadFactoryValue);
        ManagementCommunicationService managementCommunicationService = new ManagementCommunicationService();
        batchBuilder.addService(ManagementCommunicationService.SERVICE_NAME, (Service)managementCommunicationService).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{managementElement.getInterfaceName()}), NetworkInterfaceBinding.class, managementCommunicationService.getInterfaceInjector()).addInjection(managementCommunicationService.getPortInjector(), (Object)managementElement.getPort()).addDependency(executorServiceName, ExecutorService.class, managementCommunicationService.getExecutorServiceInjector()).addDependency(threadFactoryServiceName, ThreadFactory.class, managementCommunicationService.getThreadFactoryInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
        ManagementOperationHandlerService<ServerManagerOperationHandler> operationHandlerService = new ManagementOperationHandlerService<ServerManagerOperationHandler>(new ServerManagerOperationHandler(this));
        batchBuilder.addService(ManagementCommunicationService.SERVICE_NAME.append(new String[]{"server", "manager"}), operationHandlerService).addDependency(ManagementCommunicationService.SERVICE_NAME, ManagementCommunicationService.class, (Injector)new ManagementCommunicationServiceInjector((Value<? extends ManagementOperationHandler>)operationHandlerService));
        ManagementOperationHandlerService<ServerToServerManagerOperationHandler> serverOperationHandlerService = new ManagementOperationHandlerService<ServerToServerManagerOperationHandler>(new ServerToServerManagerOperationHandler(this));
        batchBuilder.addService(ManagementCommunicationService.SERVICE_NAME.append(new String[]{"server", "to", "server", "manager"}), serverOperationHandlerService).addDependency(ManagementCommunicationService.SERVICE_NAME, ManagementCommunicationService.class, (Injector)new ManagementCommunicationServiceInjector((Value<? extends ManagementOperationHandler>)serverOperationHandlerService));
    }

    void setDomainControllerConnection(DomainControllerConnection domainControllerConnection) {
        this.domainControllerConnection = domainControllerConnection;
        FallbackRepository repository = new FallbackRepository(this.fileRepository, domainControllerConnection.getRemoteFileRepository());
        this.modelManager.setFileRepository(repository);
        this.remoteBackedRepository = repository;
    }

    void setManagementSocketAddress(InetSocketAddress managementSocketAddress) {
        this.managementSocketAddress = managementSocketAddress;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    protected DomainModel getDomainModel() {
        return this.modelManager.getDomainModel();
    }

    protected HostModel getHostModel() {
        return this.modelManager.getHostModel();
    }

    public void setDomain(DomainModel domain) {
        this.modelManager.setDomainModel(domain);
    }

    public ManagedServer getServer(String name) {
        return this.servers.get(name);
    }

    private void checkState(ManagedServer server, ServerState expected) {
        ServerState state = server.getState();
        if (state != expected) {
            log.warnf("Server %s is not in the expected %s state: %s", (Object)server.getServerProcessName(), (Object)expected, (Object)state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ManagedServer> getServers() {
        Map<String, ManagedServer> map = this.servers;
        synchronized (map) {
            return Collections.unmodifiableMap(this.servers);
        }
    }

    private void synchronizeDeployments() {
        DomainModel domainConfig = this.getDomainModel();
        Set serverGroupNames = domainConfig.getServerGroupNames();
        for (ServerElement server : this.getHostModel().getServers()) {
            String serverGroupName = server.getServerGroup();
            if (!serverGroupNames.remove(serverGroupName)) continue;
            for (ServerGroupDeploymentElement deployment : domainConfig.getServerGroup(serverGroupName).getDeployments()) {
                this.remoteBackedRepository.getDeploymentFiles(deployment.getSha1Hash());
            }
        }
    }

    void startServers() {
        if (this.serversStarted.compareAndSet(false, true) && !this.environment.isRestart()) {
            this.synchronizeDeployments();
            HostModel hostConfig = this.getHostModel();
            for (ServerElement serverEl : hostConfig.getServers()) {
                if (serverEl.isStart()) {
                    String serverName = serverEl.getName();
                    log.info((Object)("Starting server " + serverName));
                    try {
                        this.startServer(serverName, this.managementSocketAddress);
                    }
                    catch (IOException e) {
                        log.error((Object)("Failed to start server " + serverName), (Throwable)e);
                    }
                    continue;
                }
                log.info((Object)("Server " + serverEl.getName() + " is configured to not be started"));
            }
        }
    }

    public ServerStatus startServer(String serverName) {
        try {
            String processName = ManagedServer.getServerProcessName(serverName);
            ManagedServer server = this.servers.get(processName);
            boolean canStart = true;
            if (server != null) {
                if (server.getState() != ServerState.STOPPED) {
                    log.warnf("Received request to start server %s but it is not stopped; server state is ", (Object)serverName, (Object)server.getState());
                    canStart = false;
                } else {
                    server.removeServerProcess();
                    this.servers.remove(processName);
                }
            }
            if (canStart) {
                this.startServer(serverName, this.managementSocketAddress);
            }
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Failed to start server %s", (Object)serverName);
        }
        ServerStatus status = this.determineServerStatus(serverName);
        for (int i = 0; i < 50 && (status = this.determineServerStatus(serverName)) == ServerStatus.STARTING; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return status;
    }

    public ServerStatus stopServer(String serverName, long gracefulTimeout) {
        try {
            String processName = ManagedServer.getServerProcessName(serverName);
            ManagedServer server = this.servers.get(processName);
            if (server != null) {
                if (gracefulTimeout > -1L) {
                    log.warnf("Graceful shutdown of server %s was requested but is not presently supported. Falling back to rapid shutdown.", (Object)serverName);
                    server.stopServerProcess();
                    server.removeServerProcess();
                    this.servers.remove(processName);
                } else {
                    server.stopServerProcess();
                    server.removeServerProcess();
                    this.servers.remove(processName);
                }
            }
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Failed to stop server %s", (Object)serverName);
        }
        return this.determineServerStatus(serverName);
    }

    public ServerStatus restartServer(String serverName, long gracefulTimeout) {
        this.stopServer(serverName, gracefulTimeout);
        return this.startServer(serverName);
    }

    private void startServer(String serverName, InetSocketAddress managementSocket) throws IOException {
        ManagedServer server = new ManagedServer(serverName, this.getDomainModel(), this.getHostModel(), this.environment, this.processManagerClient, managementSocket);
        this.servers.put(server.getServerProcessName(), server);
        server.addServerProcess();
        server.startServerProcess();
    }

    private List<HostUpdateResult<?>> applyUpdatesToServers(List<AbstractHostModelUpdate<?>> updates, List<HostUpdateApplierResponse> hostResults, boolean allowOverallRollback) {
        HashMap serverByHost = new HashMap();
        HashMap<Object, HostUpdateResult> resultsByUpdate = new HashMap<Object, HostUpdateResult>();
        for (int i = 0; i < updates.size(); ++i) {
            AbstractHostModelUpdate<?> hostUpdate = updates.get(i);
            AbstractServerModelUpdate abstractServerModelUpdate = hostUpdate.getServerModelUpdate();
            if (abstractServerModelUpdate == null) continue;
            serverByHost.put(hostUpdate, abstractServerModelUpdate);
            resultsByUpdate.put(abstractServerModelUpdate, new HostUpdateResult());
        }
        Map<ServerIdentity, List<AbstractServerModelUpdate<?>>> updatesByServer = this.getUpdatesByServer(updates, hostResults, serverByHost);
        for (Map.Entry<ServerIdentity, List<AbstractServerModelUpdate<?>>> entry : updatesByServer.entrySet()) {
            ServerIdentity server = entry.getKey();
            List<AbstractServerModelUpdate<?>> serverUpdates = entry.getValue();
            List<UpdateResultHandlerResponse<?>> rsps = this.applyUpdatesToServer(server, serverUpdates, allowOverallRollback);
            for (int i = 0; i < serverUpdates.size(); ++i) {
                UpdateResultHandlerResponse<?> rsp = rsps.get(i);
                AbstractServerModelUpdate<?> serverUpdate = entry.getValue().get(i);
                HostUpdateResult hur = (HostUpdateResult)resultsByUpdate.get(serverUpdate);
                hur = rsp.isCancelled() ? hur.newWithAddedCancellation(server) : (rsp.isTimedOut() ? hur.newWithAddedTimeout(server) : (rsp.isRolledBack() ? hur.newWithAddedRollback(server) : (rsp.getFailureResult() != null ? hur.newWithAddedFailure(server, rsp.getFailureResult()) : hur.newWithAddedResult(server, rsp.getSuccessResult()))));
                resultsByUpdate.put(serverUpdate, hur);
            }
        }
        ArrayList result = new ArrayList();
        for (AbstractHostModelUpdate abstractHostModelUpdate : updates) {
            AbstractServerModelUpdate serverUpdate = (AbstractServerModelUpdate)serverByHost.get(abstractHostModelUpdate);
            HostUpdateResult hur = (HostUpdateResult)resultsByUpdate.get(serverUpdate);
            if (hur == null) {
                hur = new HostUpdateResult();
            }
            result.add(hur);
        }
        return result;
    }

    private Map<ServerIdentity, List<AbstractServerModelUpdate<?>>> getUpdatesByServer(List<AbstractHostModelUpdate<?>> hostUpdates, List<HostUpdateApplierResponse> hostResults, Map<AbstractHostModelUpdate<?>, AbstractServerModelUpdate<?>> serverByHost) {
        HashMap result = new HashMap();
        for (int i = 0; i < hostResults.size(); ++i) {
            HostUpdateApplierResponse domainResult = hostResults.get(i);
            AbstractHostModelUpdate<?> domainUpdate = hostUpdates.get(i);
            AbstractServerModelUpdate<?> serverUpdate = serverByHost.get(domainUpdate);
            for (ServerIdentity server : domainResult.getServers()) {
                ArrayList serverList = (ArrayList)result.get(server);
                if (serverList == null) {
                    serverList = new ArrayList();
                    result.put(server, serverList);
                }
                serverList.add(serverUpdate);
            }
        }
        return result;
    }
}

