/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.ServerSocketFactory;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.ConnectionHandler;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.ProtocolServer;
import org.jboss.as.protocol.SimpleByteDataInput;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.services.net.NetworkInterfaceBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ManagementCommunicationService
implements Service<ManagementCommunicationService>,
ConnectionHandler {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "manager", "management", "communication"});
    private final InjectedValue<NetworkInterfaceBinding> interfaceBindingValue = new InjectedValue();
    private final InjectedValue<Integer> portValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorServiceValue = new InjectedValue();
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private final ConcurrentMap<Byte, ManagementOperationHandler> handlers = new ConcurrentHashMap<Byte, ManagementOperationHandler>();
    private ProtocolServer server;

    public synchronized void start(StartContext context) throws StartException {
        ExecutorService executorService = (ExecutorService)this.executorServiceValue.getValue();
        ThreadFactory threadFactory = (ThreadFactory)this.threadFactoryValue.getValue();
        NetworkInterfaceBinding interfaceBinding = (NetworkInterfaceBinding)this.interfaceBindingValue.getValue();
        Integer port = (Integer)this.portValue.getValue();
        try {
            ProtocolServer.Configuration config = new ProtocolServer.Configuration();
            config.setBindAddress(new InetSocketAddress(interfaceBinding.getAddress(), (int)port));
            config.setThreadFactory(threadFactory);
            config.setReadExecutor((Executor)executorService);
            config.setSocketFactory(ServerSocketFactory.getDefault());
            config.setBacklog(50);
            config.setConnectionHandler((ConnectionHandler)this);
            this.server = new ProtocolServer(config);
            this.server.start();
        }
        catch (Exception e) {
            throw new StartException("Failed to start server socket", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public ManagementCommunicationService getValue() throws IllegalStateException {
        return this;
    }

    public Injector<NetworkInterfaceBinding> getInterfaceInjector() {
        return this.interfaceBindingValue;
    }

    public Injector<ExecutorService> getExecutorServiceInjector() {
        return this.executorServiceValue;
    }

    public Injector<Integer> getPortInjector() {
        return this.portValue;
    }

    public Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    void addHandler(ManagementOperationHandler handler) {
        if (this.handlers.putIfAbsent(handler.getIdentifier(), handler) != null) {
            // empty if block
        }
    }

    void removeHandler(ManagementOperationHandler handler) {
        if (!this.handlers.remove(handler.getIdentifier(), handler)) {
            // empty if block
        }
    }

    public MessageHandler handleConnected(Connection connection) throws IOException {
        return new ManagementHeaderMessageHandler();
    }

    private class ManagementHeaderMessageHandler
    implements MessageHandler {
        private ManagementHeaderMessageHandler() {
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Connection connection, InputStream dataStream) throws IOException {
            SimpleByteDataInput input = null;
            input = new SimpleByteDataInput(dataStream);
            ManagementRequestHeader requestHeader = new ManagementRequestHeader((DataInput)input);
            int workingVersion = Math.min(1, requestHeader.getVersion());
            byte handlerId = requestHeader.getOperationHandlerId();
            if (handlerId == -1) {
                throw new IOException("Management request failed.  Invalid handler id");
            }
            ManagementOperationHandler handler = (ManagementOperationHandler)ManagementCommunicationService.this.handlers.get(handlerId);
            if (handler == null) {
                String msg = null;
                if (handlerId == 117) {
                    msg = "Management request failed.  A request from a client wishing to communicate with a standalone server was received by this server manager. Server managers do not support the standalone client protocol";
                    throw new IOException(msg);
                }
                msg = "Management request failed.  No handler found for id " + handlerId;
                throw new IOException(msg);
            }
            connection.setMessageHandler((MessageHandler)handler);
            StreamUtils.safeClose((Closeable)input);
            StreamUtils.safeClose((Closeable)dataStream);
            OutputStream dataOutput = null;
            SimpleByteDataOutput output = null;
            try {
                dataOutput = connection.writeMessage();
                output = new SimpleByteDataOutput(dataOutput);
                ManagementResponseHeader responseHeader = new ManagementResponseHeader(workingVersion, requestHeader.getRequestId());
                responseHeader.write((DataOutput)output);
                output.close();
                dataOutput.close();
            }
            catch (IOException e) {
                try {
                    throw e;
                    catch (Throwable t) {
                        throw new IOException("Failed to write management response headers", t);
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.safeClose(output);
                    StreamUtils.safeClose((Closeable)dataOutput);
                    throw throwable;
                }
            }
            catch (IOException e) {
                try {
                    throw e;
                    catch (Throwable t) {
                        throw new IOException("Failed to read request header", t);
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.safeClose(input);
                    StreamUtils.safeClose((Closeable)dataStream);
                    throw throwable;
                }
            }
            StreamUtils.safeClose((Closeable)output);
            StreamUtils.safeClose((Closeable)dataOutput);
        }

        public void handleShutdown(Connection connection) throws IOException {
            connection.shutdownWrites();
        }

        public void handleFailure(Connection connection, IOException e) throws IOException {
            connection.close();
        }

        public void handleFinished(Connection connection) throws IOException {
        }
    }
}

