/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager.mgmt;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.domain.client.api.HostUpdateResult;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.ServerStatus;
import org.jboss.as.domain.controller.ModelUpdateResponse;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandlerResponse;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementResponse;
import org.jboss.as.server.manager.ServerManager;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;

public class ServerManagerOperationHandler
extends AbstractMessageHandler
implements ManagementOperationHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.management");
    private final ServerManager serverManager;

    public ServerManagerOperationHandler(ServerManager serverManager) {
        this.serverManager = serverManager;
    }

    public void handle(Connection connection, InputStream input) throws IOException {
        ProtocolUtils.expectHeader((InputStream)input, (int)2);
        byte commandCode = StreamUtils.readByte((InputStream)input);
        AbstractMessageHandler operation = this.operationFor(commandCode);
        if (operation == null) {
            throw new IOException("Invalid command code " + commandCode + " received");
        }
        log.debugf("Received ServerManager operation [%s]", (Object)operation);
        operation.handle(connection, input);
    }

    public final byte getIdentifier() {
        return 37;
    }

    private AbstractMessageHandler operationFor(byte commandByte) {
        switch (commandByte) {
            case 38: {
                return new UpdateFullDomainOperation();
            }
            case 40: {
                return new UpdateDomainModelOperation();
            }
            case 52: {
                return new UpdateHostModelOperation();
            }
            case 56: {
                return new IsActiveOperation();
            }
            case 64: {
                return new UpdateServerModelOperation();
            }
            case 70: {
                return new GetHostModelOperation();
            }
            case 81: {
                return new GetServerListOperation();
            }
            case 72: {
                return new GetServerModelOperation();
            }
            case 88: {
                return new StartServerOperation();
            }
            case 96: {
                return new StopServerOperation();
            }
            case 99: {
                return new RestartServerOperation();
            }
        }
        return null;
    }

    private static Marshaller getMarshaller() throws IOException {
        return ProtocolUtils.getMarshaller((MarshallingConfiguration)ProtocolUtils.MODULAR_CONFIG);
    }

    private static Unmarshaller getUnmarshaller() throws IOException {
        return ProtocolUtils.getUnmarshaller((MarshallingConfiguration)ProtocolUtils.MODULAR_CONFIG);
    }

    private class IsActiveOperation
    extends ManagementResponse {
        private IsActiveOperation() {
        }

        protected final byte getResponseCode() {
            return 57;
        }
    }

    private class UpdateServerModelOperation
    extends ManagementResponse {
        private List<AbstractServerModelUpdate<?>> updates;
        private String serverName;
        private boolean allowOverallRollback;

        private UpdateServerModelOperation() {
        }

        protected byte getResponseCode() {
            return 69;
        }

        protected void readRequest(InputStream input) throws IOException {
            Unmarshaller unmarshaller = ServerManagerOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)65);
            this.serverName = unmarshaller.readUTF();
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)66);
            this.allowOverallRollback = unmarshaller.readBoolean();
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)67);
            int count = unmarshaller.readInt();
            this.updates = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)68);
                AbstractServerModelUpdate update = (AbstractServerModelUpdate)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, AbstractServerModelUpdate.class);
                this.updates.add(update);
            }
            unmarshaller.finish();
            log.infof("Received server model updates %s", this.updates);
        }

        protected void sendResponse(OutputStream output) throws IOException {
            List<UpdateResultHandlerResponse<?>> responses = ServerManagerOperationHandler.this.serverManager.applyServerUpdates(this.serverName, this.updates, this.allowOverallRollback);
            Marshaller marshaller = ServerManagerOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(49);
            marshaller.writeInt(responses.size());
            for (UpdateResultHandlerResponse<?> response : responses) {
                marshaller.writeByte(50);
                marshaller.writeObject(response);
            }
            marshaller.finish();
        }
    }

    private class GetServerModelOperation
    extends ManagementResponse {
        private String serverName;

        private GetServerModelOperation() {
        }

        protected final byte getResponseCode() {
            return 80;
        }

        protected final void readRequest(InputStream input) throws IOException {
            Unmarshaller unmarshaller = ServerManagerOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)65);
            this.serverName = unmarshaller.readUTF();
            unmarshaller.finish();
        }

        protected void sendResponse(OutputStream output) throws IOException {
            ServerModel serverModel = ServerManagerOperationHandler.this.serverManager.getServerModel(this.serverName);
            Marshaller marshaller = ServerManagerOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(73);
            marshaller.writeObject((Object)serverModel);
            marshaller.finish();
        }
    }

    private abstract class ServerStatusChangeOperation
    extends ManagementResponse {
        private final boolean expectGracefulTimeout;
        private String serverName;
        private long gracefulTimeout;

        ServerStatusChangeOperation(boolean expectGracefulTimeout) {
            this.expectGracefulTimeout = expectGracefulTimeout;
        }

        protected abstract ServerStatus processChange(String var1, long var2);

        protected final void readRequest(InputStream input) throws IOException {
            Unmarshaller unmarshaller = ServerManagerOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)65);
            this.serverName = unmarshaller.readUTF();
            if (this.expectGracefulTimeout) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)97);
            }
            unmarshaller.finish();
        }

        protected void sendResponse(OutputStream output) throws IOException {
            ServerStatus serverStatus = this.processChange(this.serverName, this.gracefulTimeout);
            Marshaller marshaller = ServerManagerOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(85);
            marshaller.writeObject((Object)serverStatus);
            marshaller.finish();
        }
    }

    private class RestartServerOperation
    extends ServerStatusChangeOperation {
        private RestartServerOperation() {
            super(true);
        }

        protected byte getResponseCode() {
            return 100;
        }

        @Override
        protected ServerStatus processChange(String serverName, long gracefulTimeout) {
            return ServerManagerOperationHandler.this.serverManager.restartServer(serverName, gracefulTimeout);
        }
    }

    private class StopServerOperation
    extends ServerStatusChangeOperation {
        private StopServerOperation() {
            super(true);
        }

        protected byte getResponseCode() {
            return 98;
        }

        @Override
        protected ServerStatus processChange(String serverName, long gracefulTimeout) {
            return ServerManagerOperationHandler.this.serverManager.stopServer(serverName, gracefulTimeout);
        }
    }

    private class StartServerOperation
    extends ServerStatusChangeOperation {
        private StartServerOperation() {
            super(false);
        }

        protected byte getResponseCode() {
            return 89;
        }

        @Override
        protected ServerStatus processChange(String serverName, long gracefulTimeout) {
            return ServerManagerOperationHandler.this.serverManager.startServer(serverName);
        }
    }

    private class GetServerListOperation
    extends ManagementResponse {
        private GetServerListOperation() {
        }

        protected final byte getResponseCode() {
            return 87;
        }

        protected void sendResponse(OutputStream output) throws IOException {
            Marshaller marshaller = ServerManagerOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            Map<ServerIdentity, ServerStatus> serverStatuses = ServerManagerOperationHandler.this.serverManager.getServerStatuses();
            marshaller.writeByte(82);
            marshaller.writeInt(serverStatuses.size());
            for (Map.Entry<ServerIdentity, ServerStatus> entry : serverStatuses.entrySet()) {
                marshaller.writeByte(83);
                marshaller.writeUTF(entry.getKey().getServerName());
                marshaller.writeByte(84);
                marshaller.writeUTF(entry.getKey().getServerGroupName());
                marshaller.writeByte(85);
                marshaller.writeObject((Object)entry.getValue());
            }
            marshaller.finish();
        }
    }

    private class GetHostModelOperation
    extends ManagementResponse {
        private GetHostModelOperation() {
        }

        protected final byte getResponseCode() {
            return 71;
        }

        protected void sendResponse(OutputStream output) throws IOException {
            Marshaller marshaller = ServerManagerOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeObject((Object)ServerManagerOperationHandler.this.serverManager.getModelManager().getHostModel());
            marshaller.finish();
        }
    }

    private class UpdateHostModelOperation
    extends ManagementResponse {
        private List<AbstractHostModelUpdate<?>> updates;

        private UpdateHostModelOperation() {
        }

        protected final byte getResponseCode() {
            return 55;
        }

        protected final void readRequest(InputStream input) throws IOException {
            Unmarshaller unmarshaller = ServerManagerOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)53);
            int count = unmarshaller.readInt();
            this.updates = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)54);
                AbstractHostModelUpdate update = (AbstractHostModelUpdate)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, AbstractHostModelUpdate.class);
                this.updates.add(update);
            }
            unmarshaller.finish();
            log.infof("Received host model updates %s", this.updates);
        }

        protected void sendResponse(OutputStream output) throws IOException {
            List<HostUpdateResult<?>> responses = ServerManagerOperationHandler.this.serverManager.applyHostUpdates(this.updates);
            Marshaller marshaller = ServerManagerOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(49);
            marshaller.writeInt(responses.size());
            for (HostUpdateResult<?> response : responses) {
                marshaller.writeByte(50);
                marshaller.writeObject(response);
            }
            marshaller.finish();
        }
    }

    private class UpdateDomainModelOperation
    extends ManagementResponse {
        private List<AbstractDomainModelUpdate<?>> updates;

        private UpdateDomainModelOperation() {
        }

        protected final byte getResponseCode() {
            return 51;
        }

        protected final void readRequest(InputStream input) throws IOException {
            Unmarshaller unmarshaller = ServerManagerOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)41);
            int count = unmarshaller.readInt();
            this.updates = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)48);
                AbstractDomainModelUpdate update = (AbstractDomainModelUpdate)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, AbstractDomainModelUpdate.class);
                this.updates.add(update);
            }
            unmarshaller.finish();
            log.infof("Received domain model updates %s", this.updates);
        }

        protected void sendResponse(OutputStream output) throws IOException {
            ArrayList<ModelUpdateResponse<List<ServerIdentity>>> responses = new ArrayList<ModelUpdateResponse<List<ServerIdentity>>>(this.updates.size());
            for (AbstractDomainModelUpdate<?> update : this.updates) {
                responses.add(this.processUpdate(update));
            }
            Marshaller marshaller = ServerManagerOperationHandler.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(49);
            marshaller.writeInt(responses.size());
            for (ModelUpdateResponse modelUpdateResponse : responses) {
                marshaller.writeByte(50);
                marshaller.writeObject((Object)modelUpdateResponse);
            }
            marshaller.finish();
        }

        private ModelUpdateResponse<List<ServerIdentity>> processUpdate(AbstractDomainModelUpdate<?> update) {
            try {
                List<ServerIdentity> result = ServerManagerOperationHandler.this.serverManager.getModelManager().applyDomainModelUpdate(update, true);
                return new ModelUpdateResponse(result);
            }
            catch (UpdateFailedException e) {
                return new ModelUpdateResponse(e);
            }
        }
    }

    private class UpdateFullDomainOperation
    extends ManagementResponse {
        private UpdateFullDomainOperation() {
        }

        protected final byte getResponseCode() {
            return 39;
        }

        protected final void readRequest(InputStream input) throws IOException {
            Unmarshaller unmarshaller = ServerManagerOperationHandler.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)19);
            DomainModel domainModel = (DomainModel)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, DomainModel.class);
            ServerManagerOperationHandler.this.serverManager.setDomain(domainModel);
            unmarshaller.finish();
            log.info((Object)"Received domain update.");
        }
    }
}

