/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager.mgmt;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementResponse;
import org.jboss.as.server.manager.ManagedServer;
import org.jboss.as.server.manager.ServerManager;
import org.jboss.logging.Logger;

public class ServerToServerManagerOperationHandler
extends AbstractMessageHandler
implements ManagementOperationHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.manager.mgmt");
    private final ServerManager serverManager;

    public ServerToServerManagerOperationHandler(ServerManager serverManager) {
        this.serverManager = serverManager;
    }

    public byte getIdentifier() {
        return 127;
    }

    public void handle(Connection connection, InputStream input) throws IOException {
        ProtocolUtils.expectHeader((InputStream)input, (int)2);
        byte commandCode = StreamUtils.readByte((InputStream)input);
        AbstractMessageHandler operation = this.operationFor(commandCode);
        if (operation == null) {
            throw new IOException("Invalid command code " + commandCode + " received");
        }
        operation.handle(connection, input);
    }

    private AbstractMessageHandler operationFor(byte commandByte) {
        switch (commandByte) {
            case 0: {
                return new ServerRegisterCommand();
            }
        }
        return null;
    }

    private class ServerRegisterCommand
    extends ManagementResponse {
        private Connection connection;

        private ServerRegisterCommand() {
        }

        protected byte getResponseCode() {
            return 2;
        }

        public void handle(Connection connection, InputStream input) throws IOException {
            this.connection = connection;
            super.handle(connection, input);
        }

        protected void readRequest(InputStream input) throws IOException {
            ProtocolUtils.expectHeader((InputStream)input, (int)1);
            String serverName = StreamUtils.readUTFZBytes((InputStream)input);
            log.infof("Server [%s] registered using connection [%s]", (Object)serverName, (Object)this.connection);
            ServerManager serverManager = ServerToServerManagerOperationHandler.this.serverManager;
            String processName = ManagedServer.getServerProcessName(serverName);
            ManagedServer managedServer = serverManager.getServer(processName);
            if (managedServer == null) {
                log.errorf("Invalid server name [%s] registered", (Object)serverName);
                return;
            }
            managedServer.setServerManagementConnection(this.connection);
        }
    }
}

