/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.util.List;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.module.ModuleConfig;
import org.jboss.as.deployment.module.ModuleDependencies;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;

public class DsDependencyProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.MODULE_DEPENDENCIES.plus(120L);
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.deployer.dsdeployer");
    private final InjectedValue<DataSources> dsValue = new InjectedValue();

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        ConnectorXmlDescriptor connectorXmlDescriptor = (ConnectorXmlDescriptor)context.getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
        String deploymentName = connectorXmlDescriptor == null ? null : connectorXmlDescriptor.getDeploymentName();
        DataSources datasources = (DataSources)this.dsValue.getValue();
        if (datasources == null || deploymentName == null || !deploymentName.startsWith("jdbc")) {
            return;
        }
        log.tracef("Processing datasource deployement: %s", (Object)datasources);
        try {
            if (deploymentName.indexOf("local") != -1) {
                List dss = datasources.getDataSource();
                if (dss != null && dss.size() > 0) {
                    for (DataSource ds : dss) {
                        try {
                            log.tracef("Processing datasource deployement: %s", (Object)ds);
                            if (ds.getModule() != null && !ds.getModule().trim().equals("")) {
                                ModuleIdentifier jdbcIdentifier = ModuleIdentifier.fromString((String)ds.getModule());
                                Module jdbcModule = Module.getDefaultModuleLoader().loadModule(jdbcIdentifier);
                                ModuleDependencies.addDependency((DeploymentUnitContext)context, (ModuleConfig.Dependency)new ModuleConfig.Dependency(jdbcIdentifier, true, false, false));
                                continue;
                            }
                            log.warnf("No module defined for %s", (Object)ds.getJndiName());
                        }
                        catch (ModuleLoadException mle) {
                            log.warnf("Unable to resolve %s for %s", (Object)ds.getModule(), (Object)ds.getJndiName());
                        }
                    }
                }
            } else {
                List xadss = datasources.getXaDataSource();
                if (xadss != null && xadss.size() > 0) {
                    for (XaDataSource xads : xadss) {
                        try {
                            log.tracef("Processing xa-datasource deployement: %s", (Object)xads);
                            if (xads.getModule() != null && !xads.getModule().trim().equals("")) {
                                ModuleIdentifier jdbcIdentifier = ModuleIdentifier.fromString((String)xads.getModule());
                                Module jdbcModule = Module.getDefaultModuleLoader().loadModule(jdbcIdentifier);
                                ModuleDependencies.addDependency((DeploymentUnitContext)context, (ModuleConfig.Dependency)new ModuleConfig.Dependency(jdbcIdentifier, true, false, false));
                                continue;
                            }
                            log.warnf("No module defined for %s", (Object)xads.getJndiName());
                        }
                        catch (ModuleLoadException mle) {
                            log.warnf("Unable to resolve %s for %s", (Object)xads.getModule(), (Object)xads.getJndiName());
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException(t);
        }
    }

    public Injector<DataSources> getDsValueInjector() {
        return this.dsValue;
    }
}

