/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.model.ServerDeploymentStartStopHandler;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class JDBCRARDeployService
implements Service<JDBCRARDeployService> {
    public static final ServiceName NAME = ServiceName.JBOSS.append(new String[]{"connector", "jdbc-rar-deployer"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.deployer.dsdeployer");
    private static final ServerDeploymentStartStopHandler handler = new ServerDeploymentStartStopHandler();
    private static final String LOCAL_RAR_NAME = "jdbc-local.rar";
    private static final String XA_RAR_NAME = "jdbc-xa.rar";

    public JDBCRARDeployService getValue() throws IllegalStateException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        log.debugf("Starting JDBC RAR Deploy Service", new Object[0]);
        ServiceContainer container = context.getController().getServiceContainer();
        try {
            handler.deploy(LOCAL_RAR_NAME, LOCAL_RAR_NAME, null, container, UpdateResultHandler.NULL, null);
        }
        catch (Throwable t) {
            log.error((Object)"Could not deploy local rar", t);
        }
        try {
            handler.deploy(XA_RAR_NAME, XA_RAR_NAME, null, container, UpdateResultHandler.NULL, null);
        }
        catch (Throwable t) {
            try {
                handler.undeploy(LOCAL_RAR_NAME, container, UpdateResultHandler.NULL, null);
            }
            catch (Throwable t2) {
                log.warn((Object)"Could not undeploy local rar", t2);
            }
            log.error((Object)"Could not deploy xa rar", t);
        }
    }

    public void stop(StopContext context) {
        ServiceContainer container = context.getController().getServiceContainer();
        try {
            handler.undeploy(LOCAL_RAR_NAME, container, UpdateResultHandler.NULL, null);
        }
        catch (Throwable t) {
            log.error((Object)"Could not undeploy local rar", t);
        }
        try {
            handler.undeploy(XA_RAR_NAME, container, UpdateResultHandler.NULL, null);
        }
        catch (Throwable t) {
            log.error((Object)"Could not undeploy xa rar", t);
        }
    }
}

