/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.parser.ModuleOptionParser;
import org.jboss.security.config.parser.StaxParserUtil;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityTrustConfigParser {
    public List<IdentityTrustModuleEntry> parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        ArrayList<IdentityTrustModuleEntry> entries = new ArrayList<IdentityTrustModuleEntry>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            StartElement peekedStartElement = (StartElement)xmlEvent;
            IdentityTrustModuleEntry entry = null;
            if (!"trust-module".equals(StaxParserUtil.getStartElementName(peekedStartElement))) break;
            entry = this.getEntry(xmlEventReader);
            entries.add(entry);
        }
        return entries;
    }

    private IdentityTrustModuleEntry getEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        ControlFlag flag = null;
        StartElement policyModuleElement = (StartElement)xmlEvent;
        Iterator<Attribute> attrs = policyModuleElement.getAttributes();
        while (attrs.hasNext()) {
            Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if ("code".equals(attQName.getLocalPart())) {
                codeName = attributeValue;
            }
            if (!"flag".equals(attQName.getLocalPart())) continue;
            flag = ControlFlag.valueOf((String)attributeValue);
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        IdentityTrustModuleEntry entry = new IdentityTrustModuleEntry(codeName, options);
        entry.setControlFlag(flag);
        return entry;
    }
}

