/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;

public final class Index {
    private static final List<AnnotationTarget> EMPTY_ANNOTATION_LIST = Collections.emptyList();
    private static final List<ClassInfo> EMPTY_CLASSINFO_LIST = Collections.emptyList();
    final Map<DotName, List<AnnotationTarget>> annotations;
    final Map<DotName, List<ClassInfo>> subclasses;
    final Map<DotName, ClassInfo> classes;

    Index(Map<DotName, List<AnnotationTarget>> annotations, Map<DotName, List<ClassInfo>> subclasses, Map<DotName, ClassInfo> classes) {
        this.annotations = Collections.unmodifiableMap(annotations);
        this.classes = Collections.unmodifiableMap(classes);
        this.subclasses = Collections.unmodifiableMap(subclasses);
    }

    public List<AnnotationTarget> getAnnotationTargets(DotName annotationName) {
        List<AnnotationTarget> list = this.annotations.get(annotationName);
        return list == null ? EMPTY_ANNOTATION_LIST : Collections.unmodifiableList(list);
    }

    public List<ClassInfo> getKnownSubclasses(DotName className) {
        List<ClassInfo> list = this.subclasses.get(className);
        return list == null ? EMPTY_CLASSINFO_LIST : Collections.unmodifiableList(list);
    }

    public ClassInfo getClassByName(DotName className) {
        return this.classes.get(className);
    }

    public Collection<ClassInfo> getKnownClasses() {
        return this.classes.values();
    }

    public void printAnnotations() {
        System.out.println("Annotations:");
        for (Map.Entry<DotName, List<AnnotationTarget>> e : this.annotations.entrySet()) {
            System.out.println(e.getKey() + ":");
            for (AnnotationTarget target : e.getValue()) {
                if (target instanceof ClassInfo) {
                    System.out.println("    Class: " + target);
                    continue;
                }
                if (target instanceof FieldInfo) {
                    System.out.println("    Field: " + target);
                    continue;
                }
                if (target instanceof MethodInfo) {
                    System.out.println("    Method: " + target);
                    continue;
                }
                if (!(target instanceof MethodParameterInfo)) continue;
                System.out.println("    Parameter: " + target);
            }
        }
    }

    public void printSubclasses() {
        System.out.println("Subclasses:");
        for (Map.Entry<DotName, List<ClassInfo>> entry : this.subclasses.entrySet()) {
            System.out.println(entry.getKey() + ":");
            for (ClassInfo clazz : entry.getValue()) {
                System.out.println("    " + clazz.name());
            }
        }
    }
}

