/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.spi.Invoker;
import javax.xml.ws.spi.ServiceDelegate;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.ServiceImpl;
import org.jboss.logging.Logger;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSBusFactory;
import org.w3c.dom.Element;

public class ProviderImpl
extends org.apache.cxf.jaxws22.spi.ProviderImpl {
    protected EndpointImpl createEndpointImpl(Bus bus, String bindingId, Object implementor, WebServiceFeature ... features) {
        Boolean db = (Boolean)bus.getProperty("deployment-bus");
        if (db != null && db.booleanValue()) {
            Logger.getLogger(ProviderImpl.class).info((Object)"Cannot use the bus associated to the current deployment for starting a new endpoint, creating a new bus...");
            bus = BusFactory.newInstance().createBus();
        }
        return super.createEndpointImpl(bus, bindingId, implementor, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint createEndpoint(String bindingId, Object implementor) {
        ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            ProviderImpl.setValidThreadDefaultBus();
            DelegateEndpointImpl delegateEndpointImpl = new DelegateEndpointImpl(super.createEndpoint(bindingId, implementor));
            return delegateEndpointImpl;
        }
        finally {
            if (restoreTCCL) {
                ProviderImpl.setContextClassLoader(origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint createEndpoint(String bindingId, Object implementor, WebServiceFeature ... features) {
        ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            ProviderImpl.setValidThreadDefaultBus();
            DelegateEndpointImpl delegateEndpointImpl = new DelegateEndpointImpl(super.createEndpoint(bindingId, implementor, features));
            return delegateEndpointImpl;
        }
        finally {
            if (restoreTCCL) {
                ProviderImpl.setContextClassLoader(origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint createEndpoint(String bindingId, Class<?> implementorClass, Invoker invoker, WebServiceFeature ... features) {
        ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            ProviderImpl.setValidThreadDefaultBus();
            DelegateEndpointImpl delegateEndpointImpl = new DelegateEndpointImpl(super.createEndpoint(bindingId, implementorClass, invoker, features));
            return delegateEndpointImpl;
        }
        finally {
            if (restoreTCCL) {
                ProviderImpl.setContextClassLoader(origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDelegate createServiceDelegate(URL url, QName qname, Class cls) {
        ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            Bus bus = ProviderImpl.setValidThreadDefaultBus();
            ServiceImpl serviceImpl = new ServiceImpl(bus, url, qname, cls, new WebServiceFeature[0]);
            return serviceImpl;
        }
        finally {
            if (restoreTCCL) {
                ProviderImpl.setContextClassLoader(origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDelegate createServiceDelegate(URL wsdlDocumentLocation, QName serviceName, Class serviceClass, WebServiceFeature ... features) {
        ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            ProviderImpl.setValidThreadDefaultBus();
            ServiceDelegate serviceDelegate = super.createServiceDelegate(wsdlDocumentLocation, serviceName, serviceClass, features);
            return serviceDelegate;
        }
        finally {
            if (restoreTCCL) {
                ProviderImpl.setContextClassLoader(origClassLoader);
            }
        }
    }

    static boolean checkAndFixContextClassLoader(ClassLoader origClassLoader) {
        try {
            origClassLoader.loadClass(ProviderImpl.class.getName());
        }
        catch (Exception e) {
            ClassLoader clientClassLoader = ProviderImpl.class.getClassLoader();
            if (BusFactory.getDefaultBus((boolean)false) == null) {
                JBossWSBusFactory.getDefaultBus(clientClassLoader);
            }
            ProviderImpl.setContextClassLoader(new DelegateClassLoader(clientClassLoader, origClassLoader));
            return true;
        }
        return false;
    }

    static Bus setValidThreadDefaultBus() {
        Bus bus = BusFactory.getThreadDefaultBus((boolean)false);
        if (bus == null) {
            bus = BusFactory.newInstance().createBus();
        }
        return bus;
    }

    static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    static final class DelegateClassLoader
    extends SecureClassLoader {
        private ClassLoader delegate;
        private ClassLoader parent;

        public DelegateClassLoader(ClassLoader delegate, ClassLoader parent) {
            super(parent);
            this.delegate = delegate;
            this.parent = parent;
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            if (this.parent != null) {
                try {
                    return this.parent.loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return this.delegate.loadClass(className);
        }

        @Override
        public URL getResource(String name) {
            URL url = null;
            if (this.parent != null) {
                url = this.parent.getResource(name);
            }
            return url == null ? this.delegate.getResource(name) : url;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final ArrayList<Enumeration<URL>> foundResources = new ArrayList<Enumeration<URL>>();
            foundResources.add(this.delegate.getResources(name));
            if (this.parent != null) {
                foundResources.add(this.parent.getResources(name));
            }
            return new Enumeration<URL>(){
                private int position;
                {
                    this.position = foundResources.size() - 1;
                }

                @Override
                public boolean hasMoreElements() {
                    while (this.position >= 0) {
                        if (((Enumeration)foundResources.get(this.position)).hasMoreElements()) {
                            return true;
                        }
                        --this.position;
                    }
                    return false;
                }

                @Override
                public URL nextElement() {
                    while (this.position >= 0) {
                        try {
                            return (URL)((Enumeration)foundResources.get(this.position)).nextElement();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            --this.position;
                        }
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            URL foundResource = this.getResource(name);
            if (foundResource != null) {
                try {
                    return foundResource.openStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    static final class DelegateEndpointImpl
    extends Endpoint {
        private Endpoint delegate;

        public DelegateEndpointImpl(Endpoint delegate) {
            this.delegate = delegate;
        }

        public Binding getBinding() {
            return this.delegate.getBinding();
        }

        public Object getImplementor() {
            return this.delegate.getImplementor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(String address) {
            ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
            boolean restoreTCCL = false;
            try {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                this.delegate.publish(address);
            }
            finally {
                if (restoreTCCL) {
                    ProviderImpl.setContextClassLoader(origClassLoader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(Object serverContext) {
            ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
            boolean restoreTCCL = false;
            try {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                this.delegate.publish(serverContext);
            }
            finally {
                if (restoreTCCL) {
                    ProviderImpl.setContextClassLoader(origClassLoader);
                }
            }
        }

        public void stop() {
            this.delegate.stop();
        }

        public boolean isPublished() {
            return this.delegate.isPublished();
        }

        public List<Source> getMetadata() {
            return this.delegate.getMetadata();
        }

        public void setMetadata(List<Source> metadata) {
            this.delegate.setMetadata(metadata);
        }

        public Executor getExecutor() {
            return this.delegate.getExecutor();
        }

        public void setExecutor(Executor executor) {
            this.delegate.setExecutor(executor);
        }

        public Map<String, Object> getProperties() {
            return this.delegate.getProperties();
        }

        public void setProperties(Map<String, Object> properties) {
            this.delegate.setProperties(properties);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EndpointReference getEndpointReference(Element ... referenceParameters) {
            ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
            boolean restoreTCCL = false;
            try {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                EndpointReference endpointReference = this.delegate.getEndpointReference(referenceParameters);
                return endpointReference;
            }
            finally {
                if (restoreTCCL) {
                    ProviderImpl.setContextClassLoader(origClassLoader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
            ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
            boolean restoreTCCL = false;
            try {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                EndpointReference endpointReference = this.delegate.getEndpointReference(clazz, referenceParameters);
                return (T)endpointReference;
            }
            finally {
                if (restoreTCCL) {
                    ProviderImpl.setContextClassLoader(origClassLoader);
                }
            }
        }
    }
}

