/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.managedbean.processors;

import java.util.List;
import javax.annotation.ManagedBean;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ServiceBindingSourceDescription;
import org.jboss.as.managedbean.component.ManagedBeanComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.msc.service.ServiceName;

public class ManagedBeanAnnotationProcessor
implements DeploymentUnitProcessor {
    static final DotName MANAGED_BEAN_ANNOTATION_NAME = DotName.createSimple((String)ManagedBean.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String applicationName = moduleDescription.getAppName();
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            return;
        }
        List instances = compositeIndex.getAnnotations(MANAGED_BEAN_ANNOTATION_NAME);
        if (instances == null || instances.isEmpty()) {
            return;
        }
        for (AnnotationInstance instance : instances) {
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) {
                throw new DeploymentUnitProcessingException("The ManagedBean annotation is only allowed at the class level: " + target);
            }
            ClassInfo classInfo = (ClassInfo)target;
            String beanClassName = classInfo.name().toString();
            AnnotationValue nameValue = instance.value();
            String beanName = nameValue == null || nameValue.asString().isEmpty() ? beanClassName : nameValue.asString();
            ManagedBeanComponentDescription componentDescription = new ManagedBeanComponentDescription(beanName, beanClassName, moduleDescription.getModuleName(), applicationName);
            ServiceName baseName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{beanName});
            componentDescription.getViewClassNames().add(beanClassName);
            BindingDescription moduleBinding = new BindingDescription();
            moduleBinding.setAbsoluteBinding(true);
            moduleBinding.setBindingName("java:module/" + beanName);
            moduleBinding.setBindingType(beanClassName);
            moduleBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseName.append(new String[]{"VIEW"}).append(new String[]{beanClassName})));
            componentDescription.getBindings().add(moduleBinding);
            BindingDescription appBinding = new BindingDescription();
            appBinding.setAbsoluteBinding(true);
            appBinding.setBindingName("java:app/" + moduleDescription.getModuleName() + "/" + beanName);
            appBinding.setBindingType(beanClassName);
            appBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseName.append(new String[]{"VIEW"}).append(new String[]{beanClassName})));
            componentDescription.getBindings().add(appBinding);
            moduleDescription.addComponent((AbstractComponentDescription)componentDescription);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

