/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    ACCEPT("accept"),
    ALL("all"),
    ANY("any"),
    APPEND("append"),
    ASYNC_HANDLER("async-handler"),
    CHANGE_LEVEL("change-level"),
    CONSOLE_HANDLER("console-handler"),
    DENY("deny"),
    ENCODING("encoding"),
    FILE("file"),
    FILE_HANDLER("file-handler"),
    FILTER("filter"),
    FORMATTER("formatter"),
    HANDLER("handler"),
    HANDLERS("handlers"),
    LEVEL("level"),
    LEVEL_RANGE("level-range"),
    LOGGER("logger"),
    MATCH("match"),
    MAX_BACKUP_INDEX("max-backup-index"),
    NOT("not"),
    OVERFLOW_ACTION("overflow-action"),
    PATTERN_FORMATTER("pattern-formatter"),
    PERIODIC_ROTATING_FILE_HANDLER("periodic-rotating-file-handler"),
    PROPERTIES("properties"),
    QUEUE_LENGTH("queue-length"),
    REPLACE("replace"),
    ROOT_LOGGER("root-logger"),
    ROTATE_SIZE("rotate-size"),
    SIZE_ROTATING_FILE_HANDLER("size-rotating-file-handler"),
    SUBHANDLERS("subhandlers"),
    SUFFIX("suffix"),
    TARGET("target");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

