/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

class RootLoggerRemove
implements ModelUpdateOperationHandler {
    static final RootLoggerRemove INSTANCE = new RootLoggerRemove();
    static final String OPERATION_NAME = "remove-root-logger";

    RootLoggerRemove() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        final ModelNode subModel = context.getSubModel();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("address").set(operation.require("address"));
        compensatingOperation.get("operation").set("set-root-logger");
        compensatingOperation.get("level").set(subModel.get(new String[]{"root-logger", "level"}));
        compensatingOperation.get("handlers").set(subModel.get(new String[]{"root-logger", "handlers"}));
        subModel.get("root-logger").clear();
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceRegistry registry = context.getServiceRegistry();
                    ServiceController controller = registry.getService(LogServices.ROOT_LOGGER);
                    if (controller != null) {
                        controller.setMode(ServiceController.Mode.REMOVE);
                    }
                    if (subModel.get("root-logger").has("handlers")) {
                        LogServices.uninstallLoggerHandlers(registry, "", subModel.get(new String[]{"root-logger", "handlers"}));
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

