/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.jca.common.JBossResourceException;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.ConnectionRecord;
import org.jboss.jca.core.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.logging.Logger;
import org.jboss.security.SubjectFactory;

public abstract class AbstractConnectionManager
implements ConnectionManager {
    private final Logger log = Logger.getLogger(this.getClass());
    private final boolean trace;
    private static final String SECURITY_MGR_PATH = "java:/jaas/";
    private Pool pool;
    private String securityDomainJndiName;
    private SubjectFactory subjectFactory;
    private int allocationRetry;
    private long allocationRetryWaitMillis;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private CachedConnectionManager cachedConnectionManager;
    private String jndiName;

    protected AbstractConnectionManager() {
        this.trace = this.log.isTraceEnabled();
    }

    protected Logger getLog() {
        return this.log;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    public void setCachedConnectionManager(CachedConnectionManager cachedConnectionManager) {
        this.cachedConnectionManager = cachedConnectionManager;
    }

    @Override
    public CachedConnectionManager getCachedConnectionManager() {
        return this.cachedConnectionManager;
    }

    public void setShutDown(boolean shutDown) {
        this.shutdown.set(shutDown);
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setSecurityDomainJndiName(String securityDomainJndiName) {
        if (securityDomainJndiName != null && securityDomainJndiName.startsWith(SECURITY_MGR_PATH)) {
            securityDomainJndiName = securityDomainJndiName.substring(SECURITY_MGR_PATH.length());
            this.log.warn((Object)"WARNING: UPDATE YOUR SecurityDomainJndiName! REMOVE java:/jaas/");
        }
        this.securityDomainJndiName = securityDomainJndiName;
    }

    public String getSecurityDomainJndiName() {
        return this.securityDomainJndiName;
    }

    public SubjectFactory getSubjectFactory() {
        return this.subjectFactory;
    }

    public void setSubjectFactory(SubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        if (this.pool == null) {
            if (this.trace) {
                this.log.trace((Object)("No pooling strategy found! for connection manager : " + this));
                return null;
            }
        } else {
            return this.pool.getManagedConnectionFactory();
        }
        return null;
    }

    public void setAllocationRetry(int number) {
        if (number >= 0) {
            this.allocationRetry = number;
        }
    }

    @Override
    public int getAllocationRetry() {
        return this.allocationRetry;
    }

    public void setAllocationRetryWaitMillis(long millis) {
        if (millis > 0L) {
            this.allocationRetryWaitMillis = millis;
        }
    }

    @Override
    public long getAllocationRetryWaitMillis() {
        return this.allocationRetryWaitMillis;
    }

    public ConnectionListener getManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        return this.getManagedConnection(null, subject, cri);
    }

    protected ConnectionListener getManagedConnection(Transaction transaction, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        ResourceException failure = null;
        if (this.shutdown.get()) {
            throw new ResourceException("The connection manager is shutdown " + this.jndiName);
        }
        try {
            return this.pool.getConnection(transaction, subject, cri);
        }
        catch (ResourceException e) {
            failure = e;
            if (this.allocationRetry != 0) {
                for (int i = 0; i < this.allocationRetry; ++i) {
                    if (this.shutdown.get()) {
                        throw new ResourceException("The connection manager is shutdown " + this.jndiName);
                    }
                    if (this.trace) {
                        this.log.trace((Object)("Attempting allocation retry for cri=" + cri));
                    }
                    try {
                        if (this.allocationRetryWaitMillis != 0L) {
                            Thread.sleep(this.allocationRetryWaitMillis);
                        }
                        return this.pool.getConnection(transaction, subject, cri);
                    }
                    catch (ResourceException re) {
                        failure = re;
                        continue;
                    }
                    catch (InterruptedException ie) {
                        JBossResourceException.rethrowAsResourceException((String)("getManagedConnection retry wait was interrupted " + this.jndiName), (Throwable)ie);
                    }
                }
            }
            throw new ResourceException("Unable to get managed connection for " + this.jndiName, (Throwable)failure);
        }
    }

    @Override
    public void returnManagedConnection(ConnectionListener cl, boolean kill) {
        Pool localStrategy = cl.getPool();
        if (localStrategy != this.pool) {
            kill = true;
        }
        try {
            if (!kill && cl.getState().equals((Object)ConnectionState.NORMAL)) {
                cl.tidyup();
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during tidy up connection" + cl), t);
            kill = true;
        }
        try {
            localStrategy.returnConnection(cl, kill);
        }
        catch (ResourceException re) {
            if (kill) {
                this.log.debug((Object)"resourceException killing connection (error retrieving from pool?)", (Throwable)re);
            }
            this.log.warn((Object)("resourceException returning connection: " + cl.getManagedConnection()), (Throwable)re);
        }
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        if (this.pool == null) {
            throw new ResourceException("You are trying to use a connection factory that has been shut down: ManagedConnectionFactory is null.");
        }
        if (!this.pool.getManagedConnectionFactory().equals(mcf)) {
            throw new ResourceException("Wrong ManagedConnectionFactory sent to allocateConnection!");
        }
        Subject subject = this.getSubject();
        ConnectionListener cl = this.getManagedConnection(subject, cri);
        this.reconnectManagedConnection(cl);
        Object connection = null;
        try {
            connection = cl.getManagedConnection().getConnection(subject, cri);
        }
        catch (Throwable t) {
            try {
                this.managedConnectionDisconnected(cl);
            }
            catch (ResourceException re) {
                this.log.trace((Object)("Get exception from managedConnectionDisconnected, maybe delist() have problem" + (Object)((Object)re)));
                this.returnManagedConnection(cl, true);
            }
            JBossResourceException.rethrowAsResourceException((String)("Unchecked throwable in ManagedConnection.getConnection() cl=" + cl), (Throwable)t);
        }
        this.registerAssociation(cl, connection);
        if (this.cachedConnectionManager != null) {
            this.cachedConnectionManager.registerConnection(this, cl, connection, cri);
        }
        return connection;
    }

    @Override
    public void disconnect(Collection<ConnectionRecord> conRecords, Set<String> unsharableResources) throws ResourceException {
        if (unsharableResources.contains(this.jndiName)) {
            this.log.trace((Object)"disconnect for unshareable connection: nothing to do");
            return;
        }
        HashSet<ConnectionListener> cls = new HashSet<ConnectionListener>(conRecords.size());
        for (ConnectionRecord cr : conRecords) {
            ConnectionListener cl = cr.getConnectionListener();
            cr.setConnectionListener(null);
            this.unregisterAssociation(cl, cr.getConnection());
            if (cls.contains(cl)) continue;
            cls.add(cl);
        }
        Iterator<ConnectionRecord> i = cls.iterator();
        while (i.hasNext()) {
            this.disconnectManagedConnection((ConnectionListener)((Object)i.next()));
        }
    }

    @Override
    public void reconnect(Collection<ConnectionRecord> conns, Set<String> unsharableResources) throws ResourceException {
        if (unsharableResources.contains(this.jndiName)) {
            this.log.trace((Object)"reconnect for unshareable connection: nothing to do");
            return;
        }
        HashMap<ConnectionRequestInfo, ConnectionListener> criToCLMap = new HashMap<ConnectionRequestInfo, ConnectionListener>(conns.size());
        for (ConnectionRecord cr : conns) {
            ConnectionListener cl;
            if (cr.getConnectionListener() != null) {
                this.log.warn((Object)("reconnecting a connection handle that still has a managedConnection! " + cr.getConnectionListener().getManagedConnection() + " " + cr.getConnection()));
            }
            if ((cl = (ConnectionListener)criToCLMap.get(cr.getCri())) == null) {
                cl = this.getManagedConnection(this.getSubject(), cr.getCri());
                criToCLMap.put(cr.getCri(), cl);
                this.reconnectManagedConnection(cl);
            }
            cl.getManagedConnection().associateConnection(cr.getConnection());
            this.registerAssociation(cl, cr.getConnection());
            cr.setConnectionListener(cl);
        }
    }

    @Override
    public void unregisterAssociation(ConnectionListener cl, Object c) {
        cl.unregisterConnection(c);
    }

    protected void reconnectManagedConnection(ConnectionListener cl) throws ResourceException {
        try {
            this.managedConnectionReconnected(cl);
        }
        catch (Throwable t) {
            this.disconnectManagedConnection(cl);
            JBossResourceException.rethrowAsResourceException((String)("Unchecked throwable in managedConnectionReconnected() cl=" + cl), (Throwable)t);
        }
    }

    protected void disconnectManagedConnection(ConnectionListener cl) {
        try {
            this.managedConnectionDisconnected(cl);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Unchecked throwable in managedConnectionDisconnected() cl=" + cl), t);
        }
    }

    protected void managedConnectionReconnected(ConnectionListener cl) throws ResourceException {
    }

    protected void managedConnectionDisconnected(ConnectionListener cl) throws ResourceException {
    }

    private void registerAssociation(ConnectionListener cl, Object c) throws ResourceException {
        cl.registerConnection(c);
    }

    @Override
    public abstract void transactionStarted(Collection<ConnectionRecord> var1) throws SystemException;

    @Override
    public abstract TransactionManager getTransactionManager();

    @Override
    public abstract boolean isTransactional();

    private Subject getSubject() {
        Subject subject = null;
        if (this.subjectFactory != null && this.securityDomainJndiName != null) {
            subject = this.subjectFactory.createSubject(this.securityDomainJndiName);
        }
        if (this.trace) {
            this.log.trace((Object)("subject: " + subject));
        }
        return subject;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new IOException("This method is not supported");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new IOException("This method is not supported");
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new NotSerializableException("This method is not supported");
    }
}

