/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager;

import javax.resource.spi.TransactionSupport;
import javax.transaction.TransactionManager;
import org.jboss.jca.core.connectionmanager.AbstractConnectionManager;
import org.jboss.jca.core.connectionmanager.NoTxConnectionManager;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.connectionmanager.notx.NoTxConnectionManagerImpl;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.transaction.TransactionSynchronizer;
import org.jboss.jca.core.connectionmanager.tx.TxConnectionManagerImpl;
import org.jboss.security.SubjectFactory;

public class ConnectionManagerFactory {
    public NoTxConnectionManager createNonTransactional(TransactionSupport.TransactionSupportLevel tsl, Pool pool, SubjectFactory subjectFactory, Integer allocationRetry, Long allocationRetryWaitMillis) {
        if (tsl == null) {
            throw new IllegalArgumentException("TransactionSupportLevel is null");
        }
        if (pool == null) {
            throw new IllegalArgumentException("Pool is null");
        }
        NoTxConnectionManagerImpl cm = null;
        switch (tsl) {
            case NoTransaction: {
                cm = new NoTxConnectionManagerImpl();
                break;
            }
            case LocalTransaction: {
                throw new IllegalArgumentException("Transactional connection manager not supported");
            }
            case XATransaction: {
                throw new IllegalArgumentException("Transactional connection manager not supported");
            }
            default: {
                throw new IllegalArgumentException("Unknown transaction support level " + tsl);
            }
        }
        cm.setSubjectFactory(subjectFactory);
        this.setProperties(cm, pool, allocationRetry, allocationRetryWaitMillis, null);
        this.setNoTxProperties(cm);
        return cm;
    }

    public TxConnectionManager createTransactional(TransactionSupport.TransactionSupportLevel tsl, Pool pool, SubjectFactory subjectFactory, Integer allocationRetry, Long allocationRetryWaitMillis, TransactionManager tm, Boolean interleaving, Integer xaResourceTimeout, Boolean isSameRMOverride, Boolean wrapXAResource, Boolean padXid) {
        if (tsl == null) {
            throw new IllegalArgumentException("TransactionSupportLevel is null");
        }
        if (pool == null) {
            throw new IllegalArgumentException("Pool is null");
        }
        if (tm == null) {
            throw new IllegalArgumentException("TransactionManager is null");
        }
        TxConnectionManagerImpl cm = null;
        switch (tsl) {
            case NoTransaction: {
                throw new IllegalArgumentException("Non transactional connection manager not supported");
            }
            case LocalTransaction: {
                cm = new TxConnectionManagerImpl(tm, true);
                break;
            }
            case XATransaction: {
                cm = new TxConnectionManagerImpl(tm, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown transaction support level " + tsl);
            }
        }
        cm.setSubjectFactory(subjectFactory);
        this.setProperties(cm, pool, allocationRetry, allocationRetryWaitMillis, tm);
        this.setTxProperties(cm, interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
        this.handleTxIntegration(tm);
        return cm;
    }

    private void setProperties(AbstractConnectionManager cm, Pool pool, Integer allocationRetry, Long allocationRetryWaitMillis, TransactionManager tm) {
        pool.setConnectionListenerFactory(cm);
        cm.setPool(pool);
        if (allocationRetry != null) {
            cm.setAllocationRetry(allocationRetry);
        }
        if (allocationRetryWaitMillis != null) {
            cm.setAllocationRetryWaitMillis(allocationRetryWaitMillis);
        }
        CachedConnectionManager ccm = new CachedConnectionManager(tm);
        cm.setCachedConnectionManager(ccm);
    }

    private void setNoTxProperties(NoTxConnectionManagerImpl cm) {
    }

    private void setTxProperties(TxConnectionManagerImpl cm, Boolean interleaving, Integer xaResourceTimeout, Boolean isSameRMOverride, Boolean wrapXAResource, Boolean padXid) {
        if (interleaving != null) {
            cm.setInterleaving(interleaving);
        }
        if (xaResourceTimeout != null) {
            cm.setXAResourceTimeout(xaResourceTimeout);
        }
        if (isSameRMOverride != null) {
            cm.setIsSameRMOverride(isSameRMOverride);
        }
        if (wrapXAResource != null) {
            cm.setWrapXAResource(wrapXAResource);
        }
        if (padXid != null) {
            cm.setPadXid(padXid);
        }
    }

    public void handleTxIntegration(TransactionManager tm) {
        TransactionSynchronizer.setTransactionManager(tm);
    }
}

