/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.xa;

import javax.resource.ResourceException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.xa.JBossLocalXAException;
import org.jboss.logging.Logger;
import org.jboss.tm.LastResource;

public class LocalXAResource
implements XAResource,
LastResource {
    private static Logger log = Logger.getLogger(LocalXAResource.class);
    private ConnectionListener cl;
    private boolean trace = log.isTraceEnabled();
    private ConnectionManager connectionManager = null;
    private boolean warned = false;
    private Xid currentXid;

    public LocalXAResource(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setConnectionListener(ConnectionListener cl) {
        this.cl = cl;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.trace) {
            log.trace((Object)("start, xid: " + xid + ", flags: " + flags));
        }
        if (this.currentXid != null && flags == 0) {
            throw new JBossLocalXAException("Trying to start a new tx when old is not complete! old: " + this.currentXid + ", new " + xid + ", flags " + flags, -6);
        }
        if (this.currentXid == null && flags != 0) {
            throw new JBossLocalXAException("Trying to start a new tx with wrong flags!  new " + xid + ", flags " + flags, -6);
        }
        if (this.currentXid == null) {
            try {
                this.cl.getManagedConnection().getLocalTransaction().begin();
            }
            catch (ResourceException re) {
                throw new JBossLocalXAException("Error trying to start local tx: ", -3, re);
            }
            catch (Throwable t) {
                throw new JBossLocalXAException("Throwable trying to start local transaction!", -3, t);
            }
            this.currentXid = xid;
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (this.trace) {
            log.trace((Object)("end on xid: " + xid + " called with flags " + flags));
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (!xid.equals(this.currentXid)) {
            throw new JBossLocalXAException("wrong xid in commit: expected: " + this.currentXid + ", got: " + xid, -6);
        }
        this.currentXid = null;
        try {
            this.cl.getManagedConnection().getLocalTransaction().commit();
        }
        catch (ResourceException re) {
            this.connectionManager.returnManagedConnection(this.cl, true);
            if (this.trace) {
                log.trace((Object)"commit problem: ", (Throwable)re);
            }
            throw new JBossLocalXAException("could not commit local tx", 100, re);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        throw new JBossLocalXAException("forget not supported in local tx", -3);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource == this;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (!this.warned) {
            log.warn((Object)"Prepare called on a local tx. Use of local transactions on a jta transaction with more than one branch may result in inconsistent data in some cases of failure.");
        }
        this.warned = true;
        return 0;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        throw new JBossLocalXAException("no recover with local-tx only resource managers", -3);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (!xid.equals(this.currentXid)) {
            throw new JBossLocalXAException("wrong xid in rollback: expected: " + this.currentXid + ", got: " + xid, -6);
        }
        this.currentXid = null;
        try {
            this.cl.getManagedConnection().getLocalTransaction().rollback();
        }
        catch (ResourceException re) {
            this.connectionManager.returnManagedConnection(this.cl, true);
            if (this.trace) {
                log.trace((Object)"rollback problem: ", (Throwable)re);
            }
            throw new JBossLocalXAException("could not rollback local tx", -3, re);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }
}

