/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.rar;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.core.spi.rar.Activation;
import org.jboss.jca.core.spi.rar.NotFoundException;

public class ActivationImpl
implements Activation {
    private WeakReference<ResourceAdapter> rar;
    private WeakReference<Class<?>> activationSpecClass;
    private Map<String, Class<?>> configProperties;
    private Set<String> requiredConfigProperties;

    ActivationImpl(ResourceAdapter rar, Class<?> activationSpecClass, Map<String, Class<?>> configProperties, Set<String> requiredConfigProperties) {
        this.rar = new WeakReference<ResourceAdapter>(rar);
        this.activationSpecClass = new WeakReference(activationSpecClass);
        this.configProperties = configProperties;
        this.requiredConfigProperties = requiredConfigProperties;
    }

    public Map<String, Class<?>> getConfigProperties() {
        return this.configProperties;
    }

    public Set<String> getRequiredConfigProperties() {
        return this.requiredConfigProperties;
    }

    public ActivationSpec createInstance() throws NotFoundException, InstantiationException, IllegalAccessException, ResourceException {
        Class clz = (Class)this.activationSpecClass.get();
        if (clz == null) {
            throw new NotFoundException("The activation spec class is no longer available");
        }
        ResourceAdapter ra = (ResourceAdapter)this.rar.get();
        if (ra == null) {
            throw new NotFoundException("The resource adapter is no longer available");
        }
        ActivationSpec instance = (ActivationSpec)ActivationSpec.class.cast(clz.newInstance());
        instance.setResourceAdapter(ra);
        return instance;
    }
}

