/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.jca.core.security.SecurityActions;
import org.jboss.jca.core.spi.security.Callback;
import org.jboss.logging.Logger;

public class UsersRoles
implements Callback {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(UsersRoles.class);
    private static boolean trace = log.isTraceEnabled();
    private static final String DEFAULT_USERS_PROPERTIES = "users.properties";
    private static final String DEFAULT_ROLES_PROPERTIES = "roles.properties";
    private Map<String, String> users = new HashMap<String, String>();
    private Map<String, Set<String>> roles = new HashMap<String, Set<String>>();
    private String usersProperties = null;
    private String rolesProperties = null;

    public String getUsersProperties() {
        return this.usersProperties;
    }

    public void setUsersProperties(String value) {
        this.usersProperties = value;
    }

    public String getRolesProperties() {
        return this.rolesProperties;
    }

    public void setRolesProperties(String value) {
        this.rolesProperties = value;
    }

    public Set<String> getUsers() {
        Set<String> s = this.users.keySet();
        if (s != null) {
            return Collections.unmodifiableSet(s);
        }
        return null;
    }

    public char[] getCredential(String user) {
        String pwd = this.users.get(user);
        if (pwd != null) {
            return pwd.toCharArray();
        }
        return null;
    }

    public String[] getRoles(String user) {
        Set<String> s = this.roles.get(user);
        if (s != null) {
            String[] result = new String[s.size()];
            return s.toArray(result);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Throwable {
        Set<Object> keys;
        Properties p;
        InputStream is = null;
        try {
            if (this.usersProperties != null) {
                if (trace) {
                    log.trace((Object)("users.properties: Using file: " + this.usersProperties));
                }
                is = new FileInputStream(this.usersProperties);
            } else {
                if (trace) {
                    log.trace((Object)"users.properties: Using classloader");
                }
                is = SecurityActions.getResourceAsStream(DEFAULT_USERS_PROPERTIES);
            }
            if (is != null) {
                p = new Properties();
                p.load(is);
                keys = p.keySet();
                if (keys != null && keys.size() > 0) {
                    for (String string : keys) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Adding user: " + string));
                        }
                        this.users.put(string, p.getProperty(string));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Empty users.properties file");
                }
            } else {
                log.warn((Object)"No users.properties were found");
            }
        }
        catch (IOException ioe) {
            log.error((Object)"Error while loading users.properties", (Throwable)ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
        try {
            if (this.rolesProperties != null) {
                if (trace) {
                    log.trace((Object)("roles.properties: Using file: " + this.rolesProperties));
                }
                is = new FileInputStream(this.rolesProperties);
            } else {
                if (trace) {
                    log.trace((Object)"roles.properties: Using classloader");
                }
                is = SecurityActions.getResourceAsStream(DEFAULT_ROLES_PROPERTIES);
            }
            if (is != null) {
                p = new Properties();
                p.load(is);
                keys = p.keySet();
                if (keys != null && keys.size() > 0) {
                    for (String string : keys) {
                        String value = p.getProperty(string);
                        StringTokenizer st = new StringTokenizer(value, ",");
                        HashSet<String> s = new HashSet<String>(st.countTokens());
                        while (st.hasMoreTokens()) {
                            s.add(st.nextToken().trim());
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Adding roles: " + s + " for user: " + string));
                        }
                        this.roles.put(string, s);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Empty roles.properties file");
                }
            } else {
                log.warn((Object)"No roles.properties were found");
            }
        }
        catch (IOException ioe) {
            log.error((Object)"Error while loading roles.properties", (Throwable)ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void stop() throws Throwable {
        this.users.clear();
        this.roles.clear();
    }
}

