/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.arquillian.spi.ContainerConfiguration;
import org.jboss.arquillian.spi.ContainerProfile;

public class JBossAsContainerConfiguration
implements ContainerConfiguration {
    private InetAddress bindAddress = this.getInetAddress("127.0.0.1");
    private int managementPort = 9999;
    private int jmxPort = 1090;
    private int httpPort = 8080;
    private boolean executeWithServlet;

    public ContainerProfile getContainerProfile() {
        return ContainerProfile.STANDALONE;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String host) {
        this.bindAddress = this.getInetAddress(host);
    }

    public int getManagementPort() {
        return this.managementPort;
    }

    public void setManagementPort(int managementPort) {
        this.managementPort = managementPort;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public void setJmxPort(int jmxPort) {
        this.jmxPort = jmxPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public boolean isExecuteWithServlet() {
        String val;
        if (!this.executeWithServlet && (val = System.getProperty("jboss.arquillian.executeWithServlet", null)) != null) {
            return Boolean.valueOf(val);
        }
        return this.executeWithServlet;
    }

    public void setExecuteWithServlet(boolean executeWithServlet) {
        this.executeWithServlet = executeWithServlet;
    }

    private InetAddress getInetAddress(String name) {
        try {
            return InetAddress.getByName(name);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown host: " + name);
        }
    }
}

