/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.as.txn.ArjunaTransactionManagerService;
import org.jboss.as.txn.TransactionJndiBindingProcessor;
import org.jboss.as.txn.TransactionManagerService;
import org.jboss.as.txn.TransactionSynchronizationRegistryService;
import org.jboss.as.txn.TxnServices;
import org.jboss.as.txn.UserTransactionService;
import org.jboss.as.txn.XATerminatorService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.tm.JBossXATerminator;
import org.omg.CORBA.ORB;

class TransactionSubsystemAdd
implements ModelAddOperationHandler,
BootOperationHandler {
    static final TransactionSubsystemAdd INSTANCE = new TransactionSubsystemAdd();
    private static final String INTERNAL_OBJECTSTORE_PATH = "jboss.transactions.object.store.path";
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.transactions");

    private TransactionSubsystemAdd() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        if (context instanceof BootOperationContext) {
            ((BootOperationContext)context).addDeploymentProcessor(Phase.INSTALL, 5632, (DeploymentUnitProcessor)new TransactionJndiBindingProcessor());
        }
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)operation.require("address"));
        final String bindingName = operation.get("core-environment").require("socket-binding").asString();
        final String recoveryBindingName = operation.get("recovery-environment").require("socket-binding").asString();
        final String recoveryStatusBindingName = operation.get("recovery-environment").require("status-socket-binding").asString();
        final String nodeIdentifier = operation.get("core-environment").has("node-identifier") ? operation.get(new String[]{"core-environment", "node-identifier"}).asString() : "1";
        final boolean coordinatorEnableStatistics = operation.get(new String[]{"coordinator-environment", "enable-statistics"}).asBoolean(false);
        String objectStorePathRef = "jboss.server.data.dir";
        String objectStorePath = "tx-object-store";
        int maxPorts = 10;
        int coordinatorDefaultTimeout = 300;
        ModelNode subModel = context.getSubModel();
        subModel.get(new String[]{"core-environment", "socket-binding"}).set(operation.get("core-environment").require("socket-binding"));
        subModel.get(new String[]{"core-environment", "node-identifier"}).set(operation.get(new String[]{"core-environment", "node-identifier"}));
        subModel.get(new String[]{"recovery-environment", "socket-binding"}).set(operation.get("recovery-environment").require("socket-binding"));
        subModel.get(new String[]{"recovery-environment", "status-socket-binding"}).set(operation.get(new String[]{"recovery-environment", "status-socket-binding"}));
        subModel.get(new String[]{"coordinator-environment", "enable-statistics"}).set(operation.get(new String[]{"coordinator-environment", "enable-statistics"}));
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget();
                    XATerminatorService xaTerminatorService = new XATerminatorService();
                    target.addService(TxnServices.JBOSS_TXN_XA_TERMINATOR, (Service)xaTerminatorService).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    ArjunaTransactionManagerService transactionManagerService = new ArjunaTransactionManagerService(nodeIdentifier, 10, coordinatorEnableStatistics, 300);
                    target.addService(TxnServices.JBOSS_TXN_ARJUNA_TRANSACTION_MANAGER, (Service)transactionManagerService).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"iiop", "orb"}), ORB.class, transactionManagerService.getOrbInjector()).addDependency(TxnServices.JBOSS_TXN_XA_TERMINATOR, JBossXATerminator.class, transactionManagerService.getXaTerminatorInjector()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{recoveryBindingName}), SocketBinding.class, transactionManagerService.getRecoveryBindingInjector()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{recoveryStatusBindingName}), SocketBinding.class, transactionManagerService.getStatusBindingInjector()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingName}), SocketBinding.class, transactionManagerService.getSocketProcessBindingInjector()).addDependency(AbstractPathService.pathNameOf((String)TransactionSubsystemAdd.INTERNAL_OBJECTSTORE_PATH), String.class, transactionManagerService.getPathInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    TransactionManagerService.addService(target);
                    UserTransactionService.addService(target);
                    TransactionSynchronizationRegistryService.addService(target);
                    RelativePathService.addService((String)TransactionSubsystemAdd.INTERNAL_OBJECTSTORE_PATH, (String)"tx-object-store", (String)"jboss.server.data.dir", (ServiceTarget)target);
                    try {
                        Class.forName("com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple", true, this.getClass().getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        log.warn((Object)"Could not load com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple", (Throwable)e);
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

