/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ejb3.component.ArrayKey;
import org.jboss.as.ejb3.component.EJBComponentConfiguration;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.PopulatingMap;

public abstract class EJBComponentDescription
extends AbstractComponentDescription {
    private TransactionAttributeType beanTransactionAttribute = TransactionAttributeType.REQUIRED;
    private TransactionManagementType transactionManagementType = TransactionManagementType.CONTAINER;
    private final Map<MethodIntf, TransactionAttributeType> txPerViewStyle1 = new HashMap<MethodIntf, TransactionAttributeType>();
    private final PopulatingMap<MethodIntf, Map<String, TransactionAttributeType>> txPerViewStyle2 = new PopulatingMap<MethodIntf, Map<String, TransactionAttributeType>>(){

        @Override
        Map<String, TransactionAttributeType> populate() {
            return new HashMap<String, TransactionAttributeType>();
        }
    };
    private final PopulatingMap<MethodIntf, PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>> txPerViewStyle3 = new PopulatingMap<MethodIntf, PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>>(){

        @Override
        PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>> populate() {
            return new PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>(){

                @Override
                Map<ArrayKey, TransactionAttributeType> populate() {
                    return new HashMap<ArrayKey, TransactionAttributeType>();
                }
            };
        }
    };
    private final Map<String, TransactionAttributeType> txStyle2 = new HashMap<String, TransactionAttributeType>();
    private final PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>> txStyle3 = new PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>(){

        @Override
        Map<ArrayKey, TransactionAttributeType> populate() {
            return new HashMap<ArrayKey, TransactionAttributeType>();
        }
    };

    public EJBComponentDescription(String componentName, String componentClassName, String moduleName, String applicationName) {
        super(componentName, componentClassName, moduleName, applicationName);
        this.setNamingMode(ComponentNamingMode.CREATE);
    }

    private static <K, V> V get(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public TransactionAttributeType getTransactionAttribute(MethodIntf methodIntf, String methodName, String ... methodParams) {
        assert (methodIntf != null) : "methodIntf is null";
        assert (methodName != null) : "methodName is null";
        assert (methodParams != null) : "methodParams is null";
        ArrayKey methodParamsKey = new ArrayKey(methodParams);
        TransactionAttributeType txAttr = (TransactionAttributeType)EJBComponentDescription.get((Map)EJBComponentDescription.get(EJBComponentDescription.get(this.txPerViewStyle3, methodIntf), methodName), methodParamsKey);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(EJBComponentDescription.get(this.txPerViewStyle2, methodIntf), methodName);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(this.txPerViewStyle1, methodIntf);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(EJBComponentDescription.get(this.txStyle3, methodName), methodParamsKey);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(this.txStyle2, methodName);
        if (txAttr != null) {
            return txAttr;
        }
        return this.beanTransactionAttribute;
    }

    public TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    public abstract MethodIntf getMethodIntf(String var1);

    public void setTransactionAttribute(MethodIntf methodIntf, TransactionAttributeType transactionAttribute) {
        if (methodIntf == null) {
            this.beanTransactionAttribute = transactionAttribute;
        } else {
            this.txPerViewStyle1.put(methodIntf, transactionAttribute);
        }
    }

    public void setTransactionAttribute(MethodIntf methodIntf, TransactionAttributeType transactionAttribute, String methodName) {
        if (methodIntf == null) {
            this.txStyle2.put(methodName, transactionAttribute);
        } else {
            this.txPerViewStyle2.pick(methodIntf).put(methodName, transactionAttribute);
        }
    }

    public void setTransactionAttribute(MethodIntf methodIntf, TransactionAttributeType transactionAttribute, String methodName, String ... methodParams) {
        ArrayKey methodParamsKey = new ArrayKey(methodParams);
        if (methodIntf != null) {
            this.txStyle3.pick(methodName).put(methodParamsKey, transactionAttribute);
        } else {
            this.txPerViewStyle3.pick(methodIntf).pick(methodName).put(methodParamsKey, transactionAttribute);
        }
    }

    public void setTransactionManagementType(TransactionManagementType transactionManagementType) {
        this.transactionManagementType = transactionManagementType;
    }

    public String getEJBName() {
        return this.getComponentName();
    }

    public String getEJBClassName() {
        return this.getComponentClassName();
    }

    protected void processComponentMethod(AbstractComponentConfiguration configuration, Method componentMethod) {
        super.processComponentMethod(configuration, componentMethod);
        MethodIntf methodIntf = MethodIntf.BEAN;
        this.processTxAttr((EJBComponentConfiguration)configuration, methodIntf, componentMethod);
    }

    protected void processViewMethod(AbstractComponentConfiguration configuration, Class<?> viewClass, Method viewMethod, Method componentMethod) {
        super.processViewMethod(configuration, viewClass, viewMethod, componentMethod);
        MethodIntf methodIntf = this.getMethodIntf(viewClass.getName());
        this.processTxAttr((EJBComponentConfiguration)configuration, methodIntf, viewMethod);
    }

    private void processTxAttr(EJBComponentConfiguration configuration, MethodIntf methodIntf, Method method) {
        ConcurrentHashMap<ArrayKey, TransactionAttributeType> perMethod;
        if (configuration.getTransactionManagementType().equals((Object)TransactionManagementType.BEAN)) {
            return;
        }
        String methodName = method.getName();
        TransactionAttributeType txAttr = this.getTransactionAttribute(methodIntf, methodName, EJBComponentDescription.toString(method.getParameterTypes()));
        ConcurrentMap<MethodIntf, ConcurrentMap<String, ConcurrentMap<ArrayKey, TransactionAttributeType>>> txAttrs = configuration.getTxAttrs();
        ConcurrentHashMap<String, ConcurrentHashMap<ArrayKey, TransactionAttributeType>> perMethodIntf = (ConcurrentHashMap<String, ConcurrentHashMap<ArrayKey, TransactionAttributeType>>)txAttrs.get((Object)methodIntf);
        if (perMethodIntf == null) {
            perMethodIntf = new ConcurrentHashMap<String, ConcurrentHashMap<ArrayKey, TransactionAttributeType>>();
            txAttrs.put(methodIntf, perMethodIntf);
        }
        if ((perMethod = (ConcurrentHashMap<ArrayKey, TransactionAttributeType>)perMethodIntf.get(methodName)) == null) {
            perMethod = new ConcurrentHashMap<ArrayKey, TransactionAttributeType>();
            perMethodIntf.put(methodName, perMethod);
        }
        perMethod.put(new ArrayKey(method.getParameterTypes()), txAttr);
    }

    private static String[] toString(Class<?>[] a) {
        String[] result = new String[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i].getName();
        }
        return result;
    }
}

