/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LockType;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.MethodIntf;

public abstract class SessionBeanComponentDescription
extends EJBComponentDescription {
    private boolean noInterfaceViewPresent;
    private Map<String, MethodIntf> viewTypes = new HashMap<String, MethodIntf>();
    private ConcurrencyManagementType concurrencyManagementType;
    private LockType beanLevelLockType;
    private AccessTimeout beanLevelAccessTimeout;
    private Map<EJBBusinessMethod, LockType> methodLockTypes = new ConcurrentHashMap<EJBBusinessMethod, LockType>();
    private Map<EJBBusinessMethod, AccessTimeout> methodAccessTimeouts = new ConcurrentHashMap<EJBBusinessMethod, AccessTimeout>();

    public SessionBeanComponentDescription(String componentName, String componentClassName, String moduleName, String applicationName) {
        super(componentName, componentClassName, moduleName, applicationName);
    }

    public abstract boolean allowsConcurrentAccess();

    public void addLocalBusinessInterfaceViews(Collection<String> classNames) {
        this.getViewClassNames().addAll(classNames);
        for (String viewClassName : classNames) {
            this.viewTypes.put(viewClassName, MethodIntf.LOCAL);
        }
    }

    public void addNoInterfaceView() {
        this.noInterfaceViewPresent = true;
        this.getViewClassNames().add(this.getEJBClassName());
        this.viewTypes.put(this.getEJBClassName(), MethodIntf.LOCAL);
    }

    @Override
    public MethodIntf getMethodIntf(String viewClassName) {
        MethodIntf methodIntf = this.viewTypes.get(viewClassName);
        assert (methodIntf != null) : "no view type known for " + viewClassName;
        return methodIntf;
    }

    public boolean hasNoInterfaceView() {
        return this.noInterfaceViewPresent;
    }

    public void setBeanLevelLockType(LockType locktype) {
        if (this.beanLevelLockType != null && this.beanLevelLockType != locktype) {
            throw new IllegalArgumentException(this.getEJBName() + " bean has already been marked for " + this.beanLevelLockType + " lock type. Cannot change it to " + locktype);
        }
        this.beanLevelLockType = locktype;
    }

    public LockType getBeanLevelLockType() {
        return this.beanLevelLockType;
    }

    public void setLockType(LockType lockType, String methodName, String ... methodParamTypes) {
        EJBBusinessMethod ejbMethod = new EJBBusinessMethod(methodName, methodParamTypes);
        this.methodLockTypes.put(ejbMethod, lockType);
    }

    public AccessTimeout getBeanLevelAccessTimeout() {
        return this.beanLevelAccessTimeout;
    }

    public void setBeanLevelAccessTimeout(AccessTimeout accessTimeout) {
        if (this.beanLevelAccessTimeout != null && this.beanLevelAccessTimeout != accessTimeout) {
            throw new IllegalArgumentException(this.getEJBName() + " bean has already been marked for " + this.beanLevelAccessTimeout + " access timeout. Cannot change it to " + accessTimeout);
        }
        this.beanLevelAccessTimeout = accessTimeout;
    }

    public void setAccessTimeout(AccessTimeout accessTimeout, String methodName, String ... methodParamTypes) {
        EJBBusinessMethod ejbMethod = new EJBBusinessMethod(methodName, methodParamTypes);
        this.methodAccessTimeouts.put(ejbMethod, accessTimeout);
    }

    public Map<EJBBusinessMethod, LockType> getMethodApplicableLockTypes() {
        return Collections.unmodifiableMap(this.methodLockTypes);
    }

    public Map<EJBBusinessMethod, AccessTimeout> getMethodApplicableAccessTimeouts() {
        return Collections.unmodifiableMap(this.methodAccessTimeouts);
    }

    public ConcurrencyManagementType getConcurrencyManagementType() {
        return this.concurrencyManagementType;
    }

    public void beanManagedConcurrency() {
        if (this.concurrencyManagementType != null && this.concurrencyManagementType != ConcurrencyManagementType.BEAN) {
            throw new IllegalStateException(this.getEJBName() + " bean has been marked for " + this.concurrencyManagementType + " cannot change it now!");
        }
        this.concurrencyManagementType = ConcurrencyManagementType.BEAN;
    }

    public void containerManagedConcurrency() {
        if (this.concurrencyManagementType != null && this.concurrencyManagementType != ConcurrencyManagementType.CONTAINER) {
            throw new IllegalStateException(this.getEJBName() + " bean has been marked for " + this.concurrencyManagementType + " cannot change it now!");
        }
        this.concurrencyManagementType = ConcurrencyManagementType.CONTAINER;
    }
}

