/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ejb.AccessTimeout;
import org.jboss.as.ee.component.AbstractComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentConfiguration;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.ejb3.cache.Cache;
import org.jboss.ejb3.cache.NoPassivationCache;
import org.jboss.ejb3.cache.StatefulObjectFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactoryContext;

public class StatefulSessionComponent
extends SessionBeanComponent {
    private final AccessTimeout accessTimeout = new AccessTimeout(){

        public long value() {
            return 5L;
        }

        public TimeUnit unit() {
            return TimeUnit.MINUTES;
        }

        public Class<? extends Annotation> annotationType() {
            return AccessTimeout.class;
        }
    };
    private Cache<StatefulSessionComponentInstance> cache = new NoPassivationCache();

    protected StatefulSessionComponent(StatefulSessionComponentConfiguration configuration) {
        super(configuration);
        this.cache.setStatefulObjectFactory((StatefulObjectFactory)new StatefulObjectFactory<StatefulSessionComponentInstance>(){

            public StatefulSessionComponentInstance createInstance() {
                return (StatefulSessionComponentInstance)StatefulSessionComponent.this.createInstance();
            }

            public void destroyInstance(StatefulSessionComponentInstance instance) {
                StatefulSessionComponent.this.destroyInstance((ComponentInstance)instance);
            }
        });
    }

    public Interceptor createClientInterceptor(Class<?> view) {
        Serializable sessionId = this.createSession();
        return this.createClientInterceptor(view, sessionId);
    }

    public Interceptor createClientInterceptor(Class<?> view, final Serializable sessionId) {
        return new Interceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object processInvocation(InterceptorContext context) throws Exception {
                context.putPrivateData(Serializable.class, (Object)sessionId);
                context.putPrivateData(Component.class, (Object)StatefulSessionComponent.this);
                try {
                    Object object = context.proceed();
                    return object;
                }
                finally {
                    context.putPrivateData(Serializable.class, null);
                    context.putPrivateData(Component.class, null);
                }
            }
        };
    }

    public Serializable createSession() {
        return ((StatefulSessionComponentInstance)this.getCache().create()).getId();
    }

    protected Cache<StatefulSessionComponentInstance> getCache() {
        return this.cache;
    }

    protected AbstractComponentInstance constructComponentInstance(Object instance, List<Interceptor> preDestroyInterceptors, InterceptorFactoryContext context) {
        return new StatefulSessionComponentInstance(this, instance, preDestroyInterceptors, context);
    }

    protected AccessTimeout getAccessTimeout() {
        return this.accessTimeout;
    }
}

