/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.util.concurrent.locks.ReentrantLock;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.EJBException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ejb3.component.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.ComponentInstanceInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.ejb3.cache.Identifiable;
import org.jboss.invocation.InterceptorContext;

public class StatefulSessionSynchronizationInterceptor
extends AbstractEJBInterceptor {
    private final ReentrantLock lock = new ReentrantLock(true);
    private Object transactionKey = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        StatefulSessionComponent component = StatefulSessionSynchronizationInterceptor.getComponent(context, StatefulSessionComponent.class);
        final StatefulSessionComponentInstance instance = ComponentInstanceInterceptor.getComponentInstance(context);
        AccessTimeout timeout = component.getAccessTimeout();
        boolean acquired = this.lock.tryLock(timeout.value(), timeout.unit());
        if (!acquired) {
            throw new ConcurrentAccessTimeoutException("EJB 3.1 FR 4.3.14.1 concurrent access timeout on " + context + " - could not obtain lock within " + timeout.value() + (Object)((Object)timeout.unit()));
        }
        TransactionSynchronizationRegistry transactionSynchronizationRegistry = component.getTransactionSynchronizationRegistry();
        Object currentTransactionKey = transactionSynchronizationRegistry.getTransactionKey();
        if (this.transactionKey != null) {
            if (!this.transactionKey.equals(currentTransactionKey)) {
                throw new EJBException("EJB 3.1 FR 4.6 Stateful instance " + (Object)((Object)instance) + " is already associated with tx " + this.transactionKey + " (current tx " + currentTransactionKey + ")");
            }
        } else if (currentTransactionKey != null) {
            transactionSynchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    StatefulSessionSynchronizationInterceptor.this.release(instance);
                }
            });
            this.transactionKey = currentTransactionKey;
        }
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            if (currentTransactionKey == null) {
                this.release(instance);
            }
        }
    }

    private void release(StatefulSessionComponentInstance instance) {
        this.lock.unlock();
        instance.getComponent().getCache().release((Identifiable)instance);
    }
}

