/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.Local;
import org.jboss.as.ee.component.AbstractComponentConfigProcessor;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.ServiceBindingSourceDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public class LocalEjbViewAnnotationProcessor
extends AbstractComponentConfigProcessor {
    private static final Logger logger = Logger.getLogger(LocalEjbViewAnnotationProcessor.class);

    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex compositeIndex, AbstractComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ClassInfo sessionBeanClass = compositeIndex.getClassByName(DotName.createSimple((String)componentDescription.getComponentClassName()));
        if (sessionBeanClass == null) {
            return;
        }
        if (!EjbDeploymentMarker.isEjbDeployment(deploymentUnit) || !(componentDescription instanceof SessionBeanComponentDescription)) {
            return;
        }
        SessionBeanComponentDescription sessionBeanComponentDescription = (SessionBeanComponentDescription)componentDescription;
        Collection<String> localBusinessInterfaces = this.getLocalBusinessInterfaces(sessionBeanComponentDescription, compositeIndex, sessionBeanClass);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Session bean: " + sessionBeanComponentDescription.getEJBName() + " has " + localBusinessInterfaces.size() + " local business interfaces namely: " + localBusinessInterfaces));
        }
        sessionBeanComponentDescription.addLocalBusinessInterfaceViews(localBusinessInterfaces);
        String applicationName = this.getEarName(deploymentUnit);
        String globalJNDIBaseName = "java:global/" + (applicationName != null ? applicationName + "/" : "") + sessionBeanComponentDescription.getModuleName() + "/" + sessionBeanComponentDescription.getEJBName();
        String appJNDIBaseName = "java:app/" + sessionBeanComponentDescription.getModuleName() + "/" + sessionBeanComponentDescription.getEJBName();
        String moduleJNDIBaseName = "java:module/" + sessionBeanComponentDescription.getEJBName();
        ServiceName baseServiceName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{sessionBeanComponentDescription.getComponentName()});
        for (String viewClassName : localBusinessInterfaces) {
            BindingDescription globalBinding = new BindingDescription();
            globalBinding.setAbsoluteBinding(true);
            String globalJNDIName = globalJNDIBaseName + "!" + viewClassName;
            globalBinding.setBindingName(globalJNDIName);
            globalBinding.setBindingType(viewClassName);
            globalBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName})));
            componentDescription.getBindings().add(globalBinding);
            logger.debug((Object)("Added java:global jndi binding at " + globalJNDIName + " for local view: " + viewClassName + " of session bean: " + sessionBeanComponentDescription.getEJBName()));
            BindingDescription appBinding = new BindingDescription();
            appBinding.setAbsoluteBinding(true);
            String appJNDIName = appJNDIBaseName + "!" + viewClassName;
            appBinding.setBindingName(appJNDIName);
            appBinding.setBindingType(viewClassName);
            appBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName})));
            componentDescription.getBindings().add(appBinding);
            logger.debug((Object)("Added java:app jndi binding at " + appJNDIName + " for local view: " + viewClassName + " of session bean: " + sessionBeanComponentDescription.getEJBName()));
            BindingDescription moduleBinding = new BindingDescription();
            moduleBinding.setAbsoluteBinding(true);
            String moduleJNDIName = moduleJNDIBaseName + "!" + viewClassName;
            moduleBinding.setBindingName(moduleJNDIName);
            moduleBinding.setBindingType(viewClassName);
            moduleBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName})));
            componentDescription.getBindings().add(moduleBinding);
            logger.debug((Object)("Added java:module jndi binding at " + moduleJNDIName + " for local view: " + viewClassName + " of session bean: " + sessionBeanComponentDescription.getEJBName()));
        }
    }

    private Collection<String> getLocalBusinessInterfaces(SessionBeanComponentDescription description, CompositeIndex compositeIndex, ClassInfo sessionBeanClass) throws DeploymentUnitProcessingException {
        Type[] localInterfaceTypes;
        Map annotationsOnBean = sessionBeanClass.annotations();
        if (annotationsOnBean == null || annotationsOnBean.isEmpty()) {
            String defaultLocalBusinessInterface = this.getDefaultLocalInterface(sessionBeanClass);
            if (defaultLocalBusinessInterface != null) {
                logger.debug((Object)("Session bean class: " + sessionBeanClass + " has no explicit local business interfaces, marking " + defaultLocalBusinessInterface + " as the (implicit) default local business interface"));
                return Collections.singleton(defaultLocalBusinessInterface);
            }
            return Collections.emptySet();
        }
        List ejbLocalAnnotations = (List)annotationsOnBean.get(DotName.createSimple((String)Local.class.getName()));
        if (ejbLocalAnnotations == null || ejbLocalAnnotations.isEmpty()) {
            String defaultLocalBusinessInterface = this.getDefaultLocalInterface(sessionBeanClass);
            if (defaultLocalBusinessInterface != null) {
                logger.debug((Object)("Session bean class: " + sessionBeanClass + " has no explicit local business interfaces, marking " + defaultLocalBusinessInterface + " as the (implicit) default local business interface"));
                return Collections.singleton(defaultLocalBusinessInterface);
            }
            return Collections.emptySet();
        }
        if (ejbLocalAnnotations.size() > 1) {
            throw new RuntimeException("@Local appears more than once in EJB class: " + sessionBeanClass.name());
        }
        HashSet<String> localBusinessInterfaces = new HashSet<String>();
        AnnotationInstance ejbLocalAnnotation = (AnnotationInstance)ejbLocalAnnotations.get(0);
        AnnotationTarget target = ejbLocalAnnotation.target();
        if (!(target instanceof ClassInfo)) {
            throw new RuntimeException("@Local should only appear on a class. Target: " + target + " is not a class");
        }
        AnnotationValue ejbLocalAnnValue = ejbLocalAnnotation.value();
        if (ejbLocalAnnValue == null) {
            DotName[] interfaces = sessionBeanClass.interfaces();
            if (interfaces.length != 1) {
                throw new DeploymentUnitProcessingException("Bean " + (Object)((Object)description) + " specifies @Local, but does not implement 1 interface");
            }
            localBusinessInterfaces.add(interfaces[0].toString());
            return localBusinessInterfaces;
        }
        for (Type localInterface : localInterfaceTypes = ejbLocalAnnValue.asClassArray()) {
            localBusinessInterfaces.add(localInterface.name().toString());
        }
        return localBusinessInterfaces;
    }

    private String getDefaultLocalInterface(ClassInfo sessionBeanClass) {
        DotName[] interfaces = sessionBeanClass.interfaces();
        if (interfaces == null || interfaces.length != 1) {
            return null;
        }
        return interfaces[0].toString();
    }

    private String getEarName(DeploymentUnit deploymentUnit) {
        DeploymentUnit parentDU = deploymentUnit.getParent();
        if (parentDU == null) {
            String duName = deploymentUnit.getName();
            if (duName.endsWith(".ear")) {
                return duName.substring(0, duName.length() - ".ear".length());
            }
            return null;
        }
        while (parentDU.getParent() != null) {
            parentDU = parentDU.getParent();
        }
        String duName = parentDU.getName();
        if (duName.endsWith(".ear")) {
            return duName.substring(0, duName.length() - ".ear".length());
        }
        return null;
    }
}

