/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import javax.ejb.LocalBean;
import org.jboss.as.ee.component.AbstractComponentConfigProcessor;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.ServiceBindingSourceDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public class NoInterfaceViewAnnotationProcessor
extends AbstractComponentConfigProcessor {
    private static final Logger logger = Logger.getLogger(NoInterfaceViewAnnotationProcessor.class);

    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex compositeIndex, AbstractComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ClassInfo sessionBeanClass = compositeIndex.getClassByName(DotName.createSimple((String)componentDescription.getComponentClassName()));
        if (sessionBeanClass == null) {
            return;
        }
        if (!EjbDeploymentMarker.isEjbDeployment(deploymentUnit) || !(componentDescription instanceof SessionBeanComponentDescription)) {
            return;
        }
        SessionBeanComponentDescription sessionBeanComponentDescription = (SessionBeanComponentDescription)componentDescription;
        if (!this.hasNoInterfaceView(sessionBeanClass)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Session bean: " + sessionBeanComponentDescription.getEJBName() + " doesn't have a no-interface view"));
            }
            return;
        }
        sessionBeanComponentDescription.addNoInterfaceView();
        String applicationName = this.getEarName(deploymentUnit);
        String globalJNDIBaseName = "java:global/" + (applicationName != null ? applicationName + "/" : "") + sessionBeanComponentDescription.getModuleName() + "/" + sessionBeanComponentDescription.getEJBName();
        String appJNDIBaseName = "java:app/" + sessionBeanComponentDescription.getModuleName() + "/" + sessionBeanComponentDescription.getEJBName();
        String moduleJNDIBaseName = "java:module/" + sessionBeanComponentDescription.getEJBName();
        ServiceName baseServiceName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{sessionBeanComponentDescription.getComponentName()});
        String ejbClassName = sessionBeanComponentDescription.getEJBClassName();
        BindingDescription globalBinding = new BindingDescription();
        globalBinding.setAbsoluteBinding(true);
        String globalJNDIName = globalJNDIBaseName + "!" + ejbClassName;
        globalBinding.setBindingName(globalJNDIName);
        globalBinding.setBindingType(ejbClassName);
        globalBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{ejbClassName})));
        componentDescription.getBindings().add(globalBinding);
        logger.debug((Object)("Added java:global jndi binding at " + globalJNDIName + " for no-interface view of session bean: " + sessionBeanComponentDescription.getEJBName()));
        BindingDescription appBinding = new BindingDescription();
        appBinding.setAbsoluteBinding(true);
        String appJNDIName = appJNDIBaseName + "!" + ejbClassName;
        appBinding.setBindingName(appJNDIName);
        appBinding.setBindingType(ejbClassName);
        appBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{ejbClassName})));
        componentDescription.getBindings().add(appBinding);
        logger.debug((Object)("Added java:app jndi binding at " + appJNDIName + " for no-interface view of session bean: " + sessionBeanComponentDescription.getEJBName()));
        BindingDescription moduleBinding = new BindingDescription();
        moduleBinding.setAbsoluteBinding(true);
        String moduleJNDIName = moduleJNDIBaseName + "!" + ejbClassName;
        moduleBinding.setBindingName(moduleJNDIName);
        moduleBinding.setBindingType(ejbClassName);
        moduleBinding.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{ejbClassName})));
        componentDescription.getBindings().add(moduleBinding);
        logger.debug((Object)("Added java:module jndi binding at " + moduleJNDIName + " for no-interface view of session bean: " + sessionBeanComponentDescription.getEJBName()));
    }

    private boolean hasNoInterfaceView(ClassInfo sessionBeanClass) {
        Map annotationsOnBeanClass = sessionBeanClass.annotations();
        if (annotationsOnBeanClass == null || annotationsOnBeanClass.isEmpty()) {
            return false;
        }
        List localBeanAnnotations = (List)annotationsOnBeanClass.get(DotName.createSimple((String)LocalBean.class.getName()));
        return localBeanAnnotations != null && !localBeanAnnotations.isEmpty();
    }

    private String getEarName(DeploymentUnit deploymentUnit) {
        DeploymentUnit parentDU = deploymentUnit.getParent();
        if (parentDU == null) {
            String duName = deploymentUnit.getName();
            if (duName.endsWith(".ear")) {
                return duName.substring(0, duName.length() - ".ear".length());
            }
            return null;
        }
        while (parentDU.getParent() != null) {
            parentDU = parentDU.getParent();
        }
        String duName = parentDU.getName();
        if (duName.endsWith(".ear")) {
            return duName.substring(0, duName.length() - ".ear".length());
        }
        return null;
    }
}

