/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import jline.Completor;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;

public class OperationRequestCompleter
implements Completor {
    private final CommandContext ctx;

    public OperationRequestCompleter(CommandContext ctx) {
        this.ctx = ctx;
    }

    public int complete(String buffer, int cursor, List candidates) {
        String chunk;
        if (buffer.isEmpty()) {
            return -1;
        }
        if (buffer.endsWith("..")) {
            return 0;
        }
        if (!buffer.startsWith("./") && buffer.charAt(0) != ':' && buffer.charAt(0) != '/' && !buffer.startsWith("..")) {
            return -1;
        }
        DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler(new DefaultOperationRequestAddress(this.ctx.getPrefix()));
        try {
            this.ctx.getOperationRequestParser().parse(buffer, handler);
        }
        catch (OperationFormatException e1) {
            return -1;
        }
        if (handler.isRequestComplete()) {
            return -1;
        }
        if (handler.hasProperties() || handler.endsOnArgumentListStart()) {
            if (handler.endsOnArgumentValueSeparator()) {
                return -1;
            }
            OperationCandidatesProvider provider = this.ctx.getOperationCandidatesProvider();
            List<String> propertyNames = provider.getPropertyNames(handler.getOperationName(), handler.getAddress());
            if (propertyNames.isEmpty()) {
                return -1;
            }
            if (handler.endsOnArgumentListStart()) {
                candidates.addAll(propertyNames);
                Collections.sort(candidates);
                return handler.getLastSeparatorIndex() + 1;
            }
            Set<String> specifiedNames = handler.getPropertyNames();
            String chunk2 = null;
            for (String specifiedName : specifiedNames) {
                String value = handler.getPropertyValue(specifiedName);
                if (value == null) {
                    chunk2 = specifiedName;
                    continue;
                }
                propertyNames.remove(specifiedName);
            }
            if (chunk2 == null) {
                if (handler.endsOnArgumentSeparator()) {
                    candidates.addAll(propertyNames);
                    Collections.sort(candidates);
                }
                return handler.getLastSeparatorIndex() + 1;
            }
            for (String candidate : propertyNames) {
                if (!candidate.startsWith(chunk2)) continue;
                candidates.add(candidate);
            }
            Collections.sort(candidates);
            return handler.getLastSeparatorIndex() + 1;
        }
        if (handler.hasOperationName() || handler.endsOnAddressOperationNameSeparator()) {
            OperationCandidatesProvider provider = this.ctx.getOperationCandidatesProvider();
            List<String> names = provider.getOperationNames(handler.getAddress());
            if (names.isEmpty()) {
                return -1;
            }
            String chunk3 = handler.getOperationName();
            if (chunk3 == null) {
                candidates.addAll(names);
            } else {
                for (String name : names) {
                    if (chunk3 != null && !name.startsWith(chunk3)) continue;
                    candidates.add(name);
                }
            }
            Collections.sort(candidates);
            return handler.getLastSeparatorIndex() + 1;
        }
        OperationRequestAddress address = handler.getAddress();
        if (address.isEmpty() || handler.endsOnNodeSeparator() || handler.endsOnNodeTypeNameSeparator() || address.equals(this.ctx.getPrefix()) || buffer.endsWith("..")) {
            chunk = null;
        } else if (address.endsOnType()) {
            chunk = address.getNodeType();
            address.toParentNode();
        } else {
            chunk = address.toNodeType();
        }
        OperationCandidatesProvider provider = this.ctx.getOperationCandidatesProvider();
        List<String> names = address.endsOnType() ? provider.getNodeNames(address) : provider.getNodeTypes(address);
        if (names.isEmpty()) {
            return -1;
        }
        if (chunk == null) {
            candidates.addAll(names);
        } else {
            for (String name : names) {
                if (chunk != null && !name.startsWith(chunk)) continue;
                candidates.add(name);
            }
        }
        if (candidates.size() == 1 && !address.endsOnType()) {
            String onlyType = (String)candidates.get(0);
            address.toNodeType(onlyType);
            List<String> childNames = provider.getNodeNames(address);
            if (!childNames.isEmpty()) {
                candidates.clear();
                for (String name : childNames) {
                    candidates.add(onlyType + '=' + name);
                }
            }
        }
        Collections.sort(candidates);
        return handler.getLastSeparatorIndex() + 1;
    }
}

