/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedOperationRequest;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.ValidatingOperationCallbackHandler;

public class DefaultOperationCallbackHandler
extends ValidatingOperationCallbackHandler
implements ParsedOperationRequest {
    private static final int SEPARATOR_NONE = 0;
    private static final int SEPARATOR_NODE_TYPE_NAME = 1;
    private static final int SEPARATOR_NODE = 2;
    private static final int SEPARATOR_ADDRESS_OPERATION = 3;
    private static final int SEPARATOR_OPERATION_ARGUMENTS = 4;
    private static final int SEPARATOR_ARG_NAME_VALUE = 5;
    private static final int SEPARATOR_ARG = 6;
    private int separator = 0;
    private int lastSeparatorIndex = -1;
    private boolean operationComplete;
    private String operationName;
    private OperationRequestAddress address;
    private Map<String, String> props;

    public DefaultOperationCallbackHandler() {
    }

    public DefaultOperationCallbackHandler(OperationRequestAddress prefix) {
        this.address = prefix;
    }

    @Override
    public boolean isRequestComplete() {
        return this.operationComplete;
    }

    @Override
    public boolean endsOnArgumentSeparator() {
        return this.separator == 6;
    }

    @Override
    public boolean endsOnArgumentValueSeparator() {
        return this.separator == 5;
    }

    @Override
    public boolean endsOnArgumentListStart() {
        return this.separator == 4;
    }

    @Override
    public boolean endsOnAddressOperationNameSeparator() {
        return this.separator == 3;
    }

    @Override
    public boolean endsOnNodeSeparator() {
        return this.separator == 2;
    }

    @Override
    public boolean endsOnNodeTypeNameSeparator() {
        return this.separator == 1;
    }

    @Override
    public boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public OperationRequestAddress getAddress() {
        return this.address;
    }

    @Override
    public boolean hasOperationName() {
        return this.operationName != null;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public boolean hasProperties() {
        return this.props != null && !this.props.isEmpty();
    }

    @Override
    public void validatedNodeType(String nodeType) throws OperationFormatException {
        if (this.address == null) {
            this.address = new DefaultOperationRequestAddress();
        } else if (this.address.endsOnType()) {
            throw new OperationFormatException("Can't proceed with node type '" + nodeType + "' until the node name for the previous node type has been specified.");
        }
        this.address.toNodeType(nodeType);
        this.separator = 0;
    }

    @Override
    public void nodeTypeNameSeparator(int index) {
        this.separator = 1;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void validatedNodeName(String nodeName) throws OperationFormatException {
        if (this.address == null) {
            this.address = new DefaultOperationRequestAddress();
        }
        this.address.toNode(nodeName);
        this.separator = 0;
    }

    @Override
    public void nodeSeparator(int index) {
        this.separator = 2;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void addressOperationSeparator(int index) {
        this.separator = 3;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void validatedOperationName(String operationName) throws OperationFormatException {
        this.operationName = operationName;
        this.separator = 0;
    }

    @Override
    public void propertyListStart(int index) {
        this.separator = 4;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void validatedPropertyName(String argName) throws OperationFormatException {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(argName, null);
        this.separator = 0;
    }

    @Override
    public void propertyNameValueSeparator(int index) {
        this.separator = 5;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void validatedProperty(String name, String value, int nameValueSeparatorIndex) throws OperationFormatException {
        if (value.isEmpty()) {
            throw new OperationFormatException("The argument value is missing or the format is wrong for argument '" + value + "'");
        }
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(name, value);
        this.separator = 0;
        this.lastSeparatorIndex = nameValueSeparatorIndex;
    }

    @Override
    public void propertySeparator(int index) {
        this.separator = 6;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void propertyListEnd(int index) {
        this.separator = 0;
        this.operationComplete = true;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void rootNode() {
        if (this.address == null) {
            this.address = new DefaultOperationRequestAddress();
        } else {
            this.address.reset();
        }
        this.separator = 0;
    }

    @Override
    public void parentNode() {
        if (this.address == null) {
            throw new IllegalStateException("The address hasn't been initialized yet.");
        }
        this.address.toParentNode();
        this.separator = 0;
    }

    @Override
    public void nodeType() {
        if (this.address == null) {
            throw new IllegalStateException("The address hasn't been initialized yet.");
        }
        this.address.toNodeType();
        this.separator = 0;
    }

    @Override
    public void nodeTypeOrName(String typeOrName) throws OperationFormatException {
        if (this.address == null) {
            this.address = new DefaultOperationRequestAddress();
        }
        if (this.address.endsOnType()) {
            this.nodeName(typeOrName);
        } else {
            this.nodeType(typeOrName);
        }
        this.separator = 0;
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.props == null ? Collections.emptySet() : this.props.keySet();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.props == null ? null : this.props.get(name);
    }

    @Override
    public int getLastSeparatorIndex() {
        return this.lastSeparatorIndex;
    }
}

