/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.parsing;

import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestParser;
import org.jboss.as.cli.operation.parsing.ParsingContext;
import org.jboss.as.cli.operation.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.operation.parsing.PropertyListState;
import org.jboss.as.cli.operation.parsing.PropertyState;
import org.jboss.as.cli.operation.parsing.PropertyValueState;
import org.jboss.as.cli.operation.parsing.StateParser;

public class ParsingUtil {
    public static void parseParameters(String str, final int startIndex, final OperationRequestParser.CallbackHandler opCallbackHandler) throws OperationFormatException {
        StateParser parser = new StateParser();
        PropertyValueState valueState = new PropertyValueState();
        PropertyState propState = new PropertyState(valueState);
        PropertyListState listState = new PropertyListState(propState);
        parser.addState('(', listState);
        ParsingStateCallbackHandler stateCallbackHandler = new ParsingStateCallbackHandler(){
            int nameValueSep = -1;
            StringBuilder propName = new StringBuilder();
            StringBuilder propValue = new StringBuilder();
            boolean valueContent;

            @Override
            public void enteredState(ParsingContext ctx) {
                String stateId = ctx.getState().getId();
                if (stateId.equals("PROP_LIST")) {
                    opCallbackHandler.propertyListStart(startIndex + ctx.getLocation());
                } else if (stateId.equals("PARAM")) {
                    this.propName.setLength(0);
                    this.propValue.setLength(0);
                    this.nameValueSep = -1;
                } else if (stateId.equals("PROP_VALUE")) {
                    this.nameValueSep = ctx.getLocation();
                    this.valueContent = true;
                }
            }

            @Override
            public void leavingState(ParsingContext ctx) throws OperationFormatException {
                String stateId = ctx.getState().getId();
                if (stateId.equals("PROP_LIST")) {
                    if (ctx.getCharacter() == ')') {
                        opCallbackHandler.propertyListEnd(startIndex + ctx.getLocation());
                    }
                } else if (stateId.equals("PARAM")) {
                    if (this.propValue.length() > 0) {
                        opCallbackHandler.property(this.propName.toString().trim(), this.propValue.toString().trim(), this.nameValueSep);
                    } else {
                        opCallbackHandler.propertyName(this.propName.toString().trim());
                        if (this.nameValueSep != -1) {
                            opCallbackHandler.propertyNameValueSeparator(this.nameValueSep);
                        }
                    }
                    if (ctx.getCharacter() == ',') {
                        opCallbackHandler.propertySeparator(startIndex + ctx.getLocation());
                    }
                } else if (stateId.equals("PROP_VALUE")) {
                    this.valueContent = false;
                }
            }

            @Override
            public void character(ParsingContext ctx) throws OperationFormatException {
                if (this.valueContent) {
                    this.propValue.append(ctx.getCharacter());
                } else {
                    String stateId = ctx.getState().getId();
                    if (stateId.equals("PARAM")) {
                        this.propName.append(ctx.getCharacter());
                    }
                }
            }
        };
        String paramStr = startIndex == 0 ? str : str.substring(startIndex);
        parser.parse(paramStr, stateCallbackHandler);
    }
}

