/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.aspect;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.xml.ws.spi.Provider;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.Configurer;
import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.ResourceResolver;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSBusFactory;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.configuration.NonSpringBusHolder;
import org.jboss.wsf.stack.cxf.configuration.SpringBusHolder;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.deployment.aspect.SecurityActions;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;
import org.jboss.wsf.stack.cxf.resolver.JBossWSResourceResolver;
import org.jboss.wsf.stack.cxf.transport.SoapTransportFactoryExt;

public class BusDeploymentAspect
extends AbstractDeploymentAspect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startDeploymentBus(Deployment dep) {
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        try {
            BusFactory.setThreadDefaultBus(null);
            ArchiveDeployment aDep = (ArchiveDeployment)dep;
            SecurityActions.setContextClassLoader(dep.getRuntimeClassLoader());
            ResourceResolver deploymentResolver = aDep.getResourceResolver();
            JBossWSResourceResolver resolver = new JBossWSResourceResolver(deploymentResolver);
            Map contextParams = (Map)dep.getProperty("stack.context.parameters");
            String jbosswsCxfXml = contextParams == null ? null : (String)contextParams.get("jbossws.cxf.beans.url");
            BusHolder holder = null;
            if (jbosswsCxfXml != null) {
                URL cxfServletURL = null;
                try {
                    cxfServletURL = deploymentResolver.resolve("WEB-INF/cxf-servlet.xml");
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    holder = new SpringBusHolder(cxfServletURL, deploymentResolver.resolve(jbosswsCxfXml));
                    Configurer configurer = holder.createServerConfigurer((BindingCustomization)dep.getAttachment(BindingCustomization.class), new WSDLFilePublisher(aDep), dep.getService().getEndpoints());
                    holder.configure(new SoapTransportFactoryExt(), resolver, configurer);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            DDBeans metadata = (DDBeans)dep.getAttachment(DDBeans.class);
            holder = new NonSpringBusHolder(metadata);
            Configurer configurer = holder.createServerConfigurer((BindingCustomization)dep.getAttachment(BindingCustomization.class), new WSDLFilePublisher(aDep), dep.getService().getEndpoints());
            holder.configure(new SoapTransportFactoryExt(), resolver, configurer);
            dep.addAttachment(BusHolder.class, (Object)holder);
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
            SecurityActions.setContextClassLoader(origClassLoader);
        }
    }

    public void start(Deployment dep) {
        if (BusFactory.getDefaultBus((boolean)false) == null) {
            JBossWSBusFactory.getDefaultBus((ClassLoader)Provider.provider().getClass().getClassLoader());
        }
        this.startDeploymentBus(dep);
    }

    public void stop(Deployment dep) {
        BusHolder holder = (BusHolder)dep.removeAttachment(BusHolder.class);
        if (holder != null) {
            holder.close();
        }
    }
}

