/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.ServerControllerImpl;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeployerChainsService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.ServiceLoaderProcessor;
import org.jboss.as.server.deployment.SubDeploymentProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndexProcessor;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.as.server.deployment.api.ServerDeploymentRepository;
import org.jboss.as.server.deployment.module.AdditionalModuleProcessor;
import org.jboss.as.server.deployment.module.DeploymentRootMountProcessor;
import org.jboss.as.server.deployment.module.DeploymentStructureDescriptorParser;
import org.jboss.as.server.deployment.module.ManifestAttachmentProcessor;
import org.jboss.as.server.deployment.module.ManifestClassPathProcessor;
import org.jboss.as.server.deployment.module.ManifestExtensionListProcessor;
import org.jboss.as.server.deployment.module.ManifestExtensionNameProcessor;
import org.jboss.as.server.deployment.module.ModuleClassPathProcessor;
import org.jboss.as.server.deployment.module.ModuleDependencyProcessor;
import org.jboss.as.server.deployment.module.ModuleExtensionListProcessor;
import org.jboss.as.server.deployment.module.ModuleExtensionNameProcessor;
import org.jboss.as.server.deployment.module.ModuleIdentifierProcessor;
import org.jboss.as.server.deployment.module.ModuleSpecProcessor;
import org.jboss.as.server.deployment.module.SubDeploymentDependencyProcessor;
import org.jboss.as.server.deployment.reflect.InstallReflectionIndexProcessor;
import org.jboss.as.server.deployment.service.ServiceActivatorDependencyProcessor;
import org.jboss.as.server.deployment.service.ServiceActivatorProcessor;
import org.jboss.as.server.moduleservice.ExtensionIndexService;
import org.jboss.as.server.moduleservice.ExternalModuleService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;

final class ServerControllerService
implements Service<ServerController> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server");
    private static final int DEFAULT_POOL_SIZE = 5;
    private final Bootstrap.Configuration configuration;
    private final InjectedValue<ServerDeploymentRepository> injectedDeploymentRepository = new InjectedValue();
    private final InjectedValue<ServiceModuleLoader> injectedModuleLoader = new InjectedValue();
    private final InjectedValue<ExternalModuleService> injectedExternalModuleServie = new InjectedValue();
    private ServerController serverController;

    public ServerControllerService(Bootstrap.Configuration configuration) {
        this.configuration = configuration;
    }

    public static void addService(ServiceTarget serviceTarget, Bootstrap.Configuration configuration) {
        ServerControllerService service = new ServerControllerService(configuration);
        ServiceBuilder serviceBuilder = serviceTarget.addService(Services.JBOSS_SERVER_CONTROLLER, (Service)service);
        serviceBuilder.addDependency(ServerDeploymentRepository.SERVICE_NAME, ServerDeploymentRepository.class, service.injectedDeploymentRepository);
        serviceBuilder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, service.injectedModuleLoader);
        serviceBuilder.addDependency(Services.JBOSS_EXTERNAL_MODULE_SERVICE, ExternalModuleService.class, service.injectedExternalModuleServie);
        serviceBuilder.install();
    }

    public synchronized void start(StartContext context) throws StartException {
        List updates;
        ServiceContainer container = context.getController().getServiceContainer();
        ServiceTarget serviceTarget = context.getChildTarget();
        Bootstrap.Configuration configuration = this.configuration;
        ServerEnvironment serverEnvironment = configuration.getServerEnvironment();
        ExtensibleConfigurationPersister persister = configuration.getConfigurationPersister();
        ThreadGroup threadGroup = new ThreadGroup("ServerController-threads");
        JBossThreadFactory threadFactory = new JBossThreadFactory(threadGroup, Boolean.FALSE, null, null, null, null, AccessController.getContext());
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(5, (ThreadFactory)threadFactory);
        ServerControllerImpl serverController = new ServerControllerImpl(container, serviceTarget, serverEnvironment, persister, (DeploymentRepository)this.injectedDeploymentRepository.getValue(), executorService);
        serverController.init();
        try {
            updates = persister.load();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        log.info((Object)"Activating core services");
        final AtomicInteger count = new AtomicInteger(1);
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResultFragment(String[] location, ModelNode result) {
            }

            public void handleResultComplete() {
                if (count.decrementAndGet() == 0) {
                    // empty if block
                }
            }

            public void handleFailed(ModelNode failureDescription) {
                log.errorf("Boot update failed: %s", (Object)failureDescription);
                if (count.decrementAndGet() == 0) {
                    // empty if block
                }
            }

            public void handleCancellation() {
                if (count.decrementAndGet() == 0) {
                    // empty if block
                }
            }
        };
        for (ModelNode update : updates) {
            count.incrementAndGet();
            update.get("rollback-on-runtime-failure").set(false);
            serverController.execute(OperationBuilder.Factory.create((ModelNode)update).build(), resultHandler);
        }
        if (count.decrementAndGet() == 0) {
            // empty if block
        }
        EnumMap<Phase, SortedSet<ServerControllerImpl.RegisteredProcessor>> deployers = serverController.finishBoot();
        File[] extDirs = serverEnvironment.getJavaExtDirs();
        File[] newExtDirs = Arrays.copyOf(extDirs, extDirs.length + 1);
        newExtDirs[extDirs.length] = new File(serverEnvironment.getServerBaseDir(), "lib/ext");
        serviceTarget.addService(org.jboss.as.server.deployment.Services.JBOSS_DEPLOYMENT_EXTENSION_INDEX, (Service)new ExtensionIndexService(newExtDirs)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        deployers.get((Object)Phase.STRUCTURE).add(new ServerControllerImpl.RegisteredProcessor(2560, new DeploymentUnitProcessor(){

            @Override
            public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
                phaseContext.getDeploymentUnit().putAttachment(Attachments.SERVICE_MODULE_LOADER, ServerControllerService.this.injectedModuleLoader.getValue());
                phaseContext.getDeploymentUnit().putAttachment(Attachments.EXTERNAL_MODULE_SERVICE, ServerControllerService.this.injectedExternalModuleServie.getValue());
            }

            @Override
            public void undeploy(DeploymentUnit context) {
                context.removeAttachment(Attachments.SERVICE_MODULE_LOADER);
            }
        }));
        deployers.get((Object)Phase.STRUCTURE).add(new ServerControllerImpl.RegisteredProcessor(0, new DeploymentRootMountProcessor()));
        deployers.get((Object)Phase.STRUCTURE).add(new ServerControllerImpl.RegisteredProcessor(2048, new ManifestAttachmentProcessor()));
        deployers.get((Object)Phase.STRUCTURE).add(new ServerControllerImpl.RegisteredProcessor(3584, new SubDeploymentProcessor()));
        deployers.get((Object)Phase.STRUCTURE).add(new ServerControllerImpl.RegisteredProcessor(3840, new ModuleIdentifierProcessor()));
        deployers.get((Object)Phase.STRUCTURE).add(new ServerControllerImpl.RegisteredProcessor(2816, new AnnotationIndexProcessor()));
        deployers.get((Object)Phase.PARSE).add(new ServerControllerImpl.RegisteredProcessor(512, new DeploymentStructureDescriptorParser()));
        deployers.get((Object)Phase.PARSE).add(new ServerControllerImpl.RegisteredProcessor(768, new CompositeIndexProcessor()));
        deployers.get((Object)Phase.PARSE).add(new ServerControllerImpl.RegisteredProcessor(1280, new AdditionalModuleProcessor()));
        deployers.get((Object)Phase.PARSE).add(new ServerControllerImpl.RegisteredProcessor(1536, new ManifestClassPathProcessor()));
        deployers.get((Object)Phase.PARSE).add(new ServerControllerImpl.RegisteredProcessor(1792, new ManifestExtensionListProcessor()));
        deployers.get((Object)Phase.PARSE).add(new ServerControllerImpl.RegisteredProcessor(2048, new ManifestExtensionNameProcessor()));
        deployers.get((Object)Phase.PARSE).add(new ServerControllerImpl.RegisteredProcessor(4608, new ServiceLoaderProcessor()));
        deployers.get((Object)Phase.DEPENDENCIES).add(new ServerControllerImpl.RegisteredProcessor(256, new ModuleDependencyProcessor()));
        deployers.get((Object)Phase.DEPENDENCIES).add(new ServerControllerImpl.RegisteredProcessor(1280, new ServiceActivatorDependencyProcessor()));
        deployers.get((Object)Phase.DEPENDENCIES).add(new ServerControllerImpl.RegisteredProcessor(2048, new ModuleClassPathProcessor()));
        deployers.get((Object)Phase.DEPENDENCIES).add(new ServerControllerImpl.RegisteredProcessor(2304, new ModuleExtensionListProcessor()));
        deployers.get((Object)Phase.DEPENDENCIES).add(new ServerControllerImpl.RegisteredProcessor(3584, new SubDeploymentDependencyProcessor()));
        deployers.get((Object)Phase.CONFIGURE_MODULE).add(new ServerControllerImpl.RegisteredProcessor(256, new ModuleSpecProcessor()));
        deployers.get((Object)Phase.POST_MODULE).add(new ServerControllerImpl.RegisteredProcessor(2048, new ModuleExtensionNameProcessor()));
        deployers.get((Object)Phase.INSTALL).add(new ServerControllerImpl.RegisteredProcessor(256, new InstallReflectionIndexProcessor()));
        deployers.get((Object)Phase.INSTALL).add(new ServerControllerImpl.RegisteredProcessor(1024, new ServiceActivatorProcessor()));
        EnumMap<Phase, List<DeploymentUnitProcessor>> finalDeployers = new EnumMap<Phase, List<DeploymentUnitProcessor>>(Phase.class);
        for (Map.Entry<Phase, SortedSet<ServerControllerImpl.RegisteredProcessor>> entry : deployers.entrySet()) {
            SortedSet<ServerControllerImpl.RegisteredProcessor> processorSet = entry.getValue();
            ArrayList<DeploymentUnitProcessor> list = new ArrayList<DeploymentUnitProcessor>(processorSet.size());
            for (ServerControllerImpl.RegisteredProcessor processor : processorSet) {
                list.add(processor.getProcessor());
            }
            finalDeployers.put((Phase)((Enum)entry.getKey()), list);
        }
        DeployerChainsService.addService(serviceTarget, finalDeployers);
        this.serverController = serverController;
    }

    public synchronized void stop(StopContext context) {
        this.serverController = null;
    }

    public synchronized ServerController getValue() throws IllegalStateException, IllegalArgumentException {
        return this.serverController;
    }
}

