/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitPhaseService;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractDeploymentUnitService
implements Service<DeploymentUnit> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment");
    private static final String FIRST_PHASE_NAME = Phase.values()[0].name();
    private final InjectedValue<DeployerChains> deployerChainsInjector = new InjectedValue();
    private final DeploymentCompletionCallback callback;
    private DeploymentUnit deploymentUnit;
    private static final DeploymentCompletionCallback NO_OP_CALLBACK = new DeploymentCompletionCallback(){

        @Override
        public void handleComplete() {
        }

        @Override
        public void handleFailure(Map<ServiceName, StartException> startExceptions, Set<ServiceName> failedDependencies) {
        }
    };

    protected AbstractDeploymentUnitService() {
        this(NO_OP_CALLBACK);
    }

    protected AbstractDeploymentUnitService(DeploymentCompletionCallback callback) {
        this.callback = callback;
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceTarget target = context.getChildTarget();
        String deploymentName = context.getController().getName().getSimpleName();
        DeploymentServiceListener listener = new DeploymentServiceListener(System.nanoTime(), target, deploymentName, this.callback);
        log.infof("Starting deployment of \"%s\"", (Object)deploymentName);
        target.addListener((ServiceListener)listener);
        this.deploymentUnit = this.createAndInitializeDeploymentUnit((ServiceRegistry)context.getController().getServiceContainer());
        ServiceName serviceName = this.deploymentUnit.getServiceName().append(new String[]{FIRST_PHASE_NAME});
        Phase firstPhase = Phase.values()[0];
        DeploymentUnitPhaseService<?> phaseService = DeploymentUnitPhaseService.create(this.deploymentUnit, firstPhase);
        ServiceBuilder phaseServiceBuilder = target.addService(serviceName, phaseService);
        phaseServiceBuilder.addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, phaseService.getDeployerChainsInjector());
        phaseServiceBuilder.install();
    }

    protected abstract DeploymentUnit createAndInitializeDeploymentUnit(ServiceRegistry var1);

    public synchronized void stop(StopContext context) {
        String deploymentName = context.getController().getName().getSimpleName();
        this.deploymentUnit = null;
        log.infof("Stopped deployment %s in %dms", (Object)deploymentName, (Object)((int)(context.getElapsedTime() / 1000000L)));
    }

    public synchronized DeploymentUnit getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentUnit;
    }

    Injector<DeployerChains> getDeployerChainsInjector() {
        return this.deployerChainsInjector;
    }

    static interface DeploymentCompletionCallback {
        public void handleComplete();

        public void handleFailure(Map<ServiceName, StartException> var1, Set<ServiceName> var2);
    }

    private static final class DeploymentServiceListener
    extends AbstractServiceListener<Object> {
        private final long startTime;
        private final ServiceTarget target;
        private final String deploymentName;
        private final AtomicInteger count = new AtomicInteger();
        private final Map<ServiceName, StartException> startExceptions = Collections.synchronizedMap(new HashMap());
        private final Set<ServiceName> failedDependencies = Collections.synchronizedSet(new HashSet());
        private final DeploymentCompletionCallback callback;

        public DeploymentServiceListener(long time, ServiceTarget target, String deploymentName, DeploymentCompletionCallback callback) {
            this.startTime = time;
            this.target = target;
            this.deploymentName = deploymentName;
            this.callback = callback;
        }

        public void listenerAdded(ServiceController<? extends Object> controller) {
            ServiceController.Mode mode = controller.getMode();
            if (mode == ServiceController.Mode.ACTIVE) {
                this.count.incrementAndGet();
            } else {
                controller.removeListener((ServiceListener)this);
            }
        }

        public void serviceStarted(ServiceController<? extends Object> controller) {
            controller.removeListener((ServiceListener)this);
            this.tick();
        }

        public void serviceFailed(ServiceController<? extends Object> controller, StartException reason) {
            controller.removeListener((ServiceListener)this);
            this.startExceptions.put(controller.getName(), reason);
            this.tick();
        }

        public void serviceRemoved(ServiceController<? extends Object> controller) {
            controller.removeListener((ServiceListener)this);
            this.tick();
        }

        public void dependencyFailed(ServiceController<? extends Object> controller) {
            controller.removeListener((ServiceListener)this);
            this.failedDependencies.add(controller.getName());
            this.tick();
        }

        public void dependencyUninstalled(ServiceController<? extends Object> controller) {
            controller.removeListener((ServiceListener)this);
            this.tick();
        }

        private void tick() {
            if (this.count.decrementAndGet() == 0) {
                this.target.removeListener((ServiceListener)this);
                if (this.startExceptions.isEmpty() && this.failedDependencies.isEmpty()) {
                    log.infof("Completed deployment of \"%s\" in %d ms", (Object)this.deploymentName, (Object)((System.nanoTime() - this.startTime) / 1000000L));
                    this.callback.handleComplete();
                } else {
                    StringBuilder builder = new StringBuilder("Deployment  \"%s\" failed in %d ms.  ");
                    if (!this.startExceptions.isEmpty()) {
                        builder.append("Service failures: ").append(this.startExceptions.values());
                    }
                    if (!this.failedDependencies.isEmpty()) {
                        builder.append("Failed Dependencies: ").append(this.failedDependencies);
                    }
                    log.infof(builder.toString(), (Object)this.deploymentName, (Object)((System.nanoTime() - this.startTime) / 1000000L));
                    this.callback.handleFailure(this.startExceptions, this.failedDependencies);
                }
            }
        }
    }
}

