/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.server.controller.descriptions.DeploymentDescription;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentFullReplaceHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "full-replace-deployment";
    private final DeploymentRepository deploymentRepository;
    private final ParametersValidator validator = new ParametersValidator();

    static final ModelNode getOperation(ModelNode address) {
        return Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
    }

    public DeploymentFullReplaceHandler(DeploymentRepository deploymentRepository) {
        this.deploymentRepository = deploymentRepository;
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, false));
        this.validator.registerValidator("runtime-name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.validator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        this.validator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getFullReplaceDeploymentOperation(locale);
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode rootModel;
        ModelNode deployments;
        ModelNode replaceNode;
        byte[] hash;
        String runtimeName;
        this.validator.validate(operation);
        String name = operation.require("name").asString();
        String string = runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : name;
        if (operation.hasDefined("input-stream-index") && operation.hasDefined("hash")) {
            throw new OperationFailedException(new ModelNode().set("Can't pass in both an input-stream-index and a hash"));
        }
        if (operation.hasDefined("input-stream-index")) {
            InputStream in = this.getContents(context, operation);
            try {
                hash = this.deploymentRepository.addDeploymentContent(in);
            }
            catch (IOException e) {
                throw new OperationFailedException(new ModelNode().set(e.toString()));
            }
        } else if (operation.hasDefined("hash")) {
            hash = operation.get("hash").asBytes();
            if (!this.deploymentRepository.hasDeploymentContent(hash)) {
                throw new OperationFailedException(new ModelNode().set(String.format("No deployment content with hash %s is available in the deployment content repository.", HashUtil.bytesToHexString((byte[])hash))));
            }
        } else {
            throw new OperationFailedException(new ModelNode().set("Neither an attachment or a hash were passed in"));
        }
        ModelNode modelNode = replaceNode = (deployments = (rootModel = context.getSubModel()).get("deployment")).hasDefined(name) ? deployments.get(name) : null;
        if (replaceNode == null) {
            throw new OperationFailedException(new ModelNode().set(String.format("No deployment with name %s found", name)));
        }
        boolean start = replaceNode.get("enabled").asBoolean();
        ModelNode deployNode = new ModelNode();
        deployNode.get("name").set(name);
        deployNode.get("runtime-name").set(runtimeName);
        deployNode.get("hash").set(hash);
        deployNode.get("enabled").set(start);
        deployments.get(name).set(deployNode);
        ModelNode compensatingOp = operation.clone();
        compensatingOp.get("runtime-name").set(replaceNode.get("runtime-name").asString());
        compensatingOp.get("hash").set(replaceNode.get("hash").asBytes());
        if (operation.hasDefined("input-stream-index")) {
            operation.remove("input-stream-index");
        }
        if (start) {
            DeploymentHandlerUtil.replace(deployNode, name, context, resultHandler);
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOp);
    }

    private InputStream getContents(OperationContext context, ModelNode operation) {
        int streamIndex = operation.get("input-stream-index").asInt();
        if (streamIndex > context.getInputStreams().size() - 1) {
            throw new IllegalArgumentException("Invalid input-stream-index=" + streamIndex + ", the maximum index is " + (context.getInputStreams().size() - 1));
        }
        InputStream in = (InputStream)context.getInputStreams().get(streamIndex);
        if (in == null) {
            throw new IllegalStateException("Null stream at index " + streamIndex);
        }
        return in;
    }
}

