/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.path;

import java.io.File;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class RelativePathService
extends AbstractPathService {
    private final String relativePath;
    private final InjectedValue<String> injectedPath = new InjectedValue();

    public static void addService(String name, String relativePath, String relativeTo, ServiceTarget serviceTarget) {
        RelativePathService.addService(RelativePathService.pathNameOf(name), relativePath, relativeTo, serviceTarget);
    }

    public static void addService(ServiceName name, String relativePath, String relativeTo, ServiceTarget serviceTarget) {
        RelativePathService service = new RelativePathService(relativePath);
        serviceTarget.addService(name, (Service)service).addDependency(RelativePathService.pathNameOf(relativeTo), String.class, service.injectedPath).install();
    }

    public static void addService(ServiceName name, ModelNode element, ServiceTarget serviceTarget) {
        String relativePath = element.require("path").asString();
        String relativeTo = element.require("relative-to").asString();
        RelativePathService.addService(name, relativePath, relativeTo, serviceTarget);
    }

    public RelativePathService(String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException("relativePath is null");
        }
        if (relativePath.length() == 0) {
            throw new IllegalArgumentException("relativePath is empty");
        }
        if (relativePath.charAt(0) == '/') {
            if (relativePath.length() == 1) {
                throw new IllegalArgumentException("Invalid relativePath value '/'");
            }
            this.relativePath = relativePath.substring(1);
        } else {
            if (relativePath.indexOf(":\\") == 1) {
                throw new IllegalArgumentException(relativePath + " is a Windows absolute path");
            }
            this.relativePath = RelativePathService.isWindows() ? relativePath.replace("/", File.separator) : relativePath.replace("\\", File.separator);
        }
    }

    @Override
    protected String resolvePath() {
        String base = (String)this.injectedPath.getValue();
        base = base.endsWith(File.separator) ? base.substring(0, base.length() - 1) : base;
        String relative = this.relativePath.startsWith(File.separator) ? this.relativePath.substring(0, this.relativePath.length() - 1) : this.relativePath;
        return base + File.separatorChar + relative;
    }

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }
}

