/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;
import org.jboss.logging.Logger;

public abstract class AbstractParser {
    private static Logger log = Logger.getLogger(AbstractParser.class);

    protected boolean elementAsBoolean(XMLStreamReader reader) throws XMLStreamException, ParserException {
        String elementtext = this.rawElementText(reader);
        String stringValue = this.getSubstitutionValue(elementtext);
        if (stringValue == null || stringValue.length() == 0 || stringValue.trim().equalsIgnoreCase("true") || stringValue.trim().equalsIgnoreCase("false")) {
            return stringValue == null || stringValue.length() == 0 ? true : Boolean.valueOf(stringValue.trim());
        }
        throw new ParserException(elementtext + " isn't a valid boolean for element " + reader.getLocalName() + ". We accept only \"true\" or \"false\" as boolean value");
    }

    protected boolean attributeAsBoolean(XMLStreamReader reader, String attributeName, boolean defaultValue) throws XMLStreamException, ParserException {
        String attributeString = this.rawAttributeText(reader, attributeName);
        String stringValue = this.getSubstitutionValue(attributeString);
        if (stringValue == null || stringValue.length() == 0 || stringValue.trim().equalsIgnoreCase("true") || stringValue.trim().equalsIgnoreCase("false")) {
            return attributeString == null ? defaultValue : Boolean.valueOf(reader.getAttributeValue("", attributeName).trim());
        }
        throw new ParserException(attributeString + " isn't a valid boolean for attribute " + attributeName + " of element " + reader.getLocalName() + ". We accept only \"true\" or \"false\" as boolean value");
    }

    protected String elementAsString(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = this.rawElementText(reader);
        return this.getSubstitutionValue(elementtext);
    }

    private String rawElementText(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = reader.getElementText();
        elementtext = elementtext == null ? null : elementtext.trim();
        return elementtext;
    }

    protected String attributeAsString(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        String attributeString = this.rawAttributeText(reader, attributeName);
        return this.getSubstitutionValue(attributeString);
    }

    private String rawAttributeText(XMLStreamReader reader, String attributeName) {
        String attributeString = reader.getAttributeValue("", attributeName) == null ? null : reader.getAttributeValue("", attributeName).trim();
        return attributeString;
    }

    protected Integer elementAsInteger(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Integer integerValue = null;
        String elementtext = this.rawElementText(reader);
        try {
            integerValue = Integer.valueOf(this.getSubstitutionValue(elementtext));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(elementtext + " isn't a valid number for element " + reader.getLocalName());
        }
        return integerValue;
    }

    protected Long elementAsLong(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Long longValue = null;
        String elementtext = this.rawElementText(reader);
        try {
            longValue = Long.valueOf(this.getSubstitutionValue(elementtext));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(elementtext + " isn't a valid number for element " + reader.getLocalName());
        }
        return longValue;
    }

    protected CommonPool parsePool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Integer minPoolSize = null;
        Integer maxPoolSize = null;
        boolean prefill = true;
        boolean useStrictMin = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.POOL) {
                        return new CommonPoolImpl(minPoolSize, maxPoolSize, prefill, useStrictMin);
                    }
                    if (CommonPool.Tag.forName((String)reader.getLocalName()) != CommonPool.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (CommonPool.Tag.forName((String)reader.getLocalName())) {
                        case MAXPOOLSIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            useStrictMin = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    protected CommonSecurity parseSecuritySettings(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String securityDomain = null;
        String securityDomainAndApplication = null;
        boolean application = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return new CommonSecurityImpl(securityDomain, securityDomainAndApplication, application);
                    }
                    if (CommonSecurity.Tag.forName((String)reader.getLocalName()) != CommonSecurity.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (CommonSecurity.Tag.forName((String)reader.getLocalName())) {
                        case SECURITY_DOMAIN: {
                            securityDomain = this.elementAsString(reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN_AND_APPLICATION: {
                            securityDomainAndApplication = this.elementAsString(reader);
                            break block0;
                        }
                        case APPLICATION: {
                            application = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    protected CommonXaPool parseXaPool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Integer minPoolSize = null;
        Integer maxPoolSize = null;
        boolean prefill = true;
        boolean interleaving = false;
        boolean isSameRmOverrideValue = false;
        boolean padXid = false;
        boolean noTxSeparatePool = false;
        boolean wrapXaDataSource = false;
        boolean useStrictMin = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.XA_POOL) {
                        return new CommonXaPoolImpl(minPoolSize, maxPoolSize, prefill, useStrictMin, isSameRmOverrideValue, interleaving, padXid, wrapXaDataSource, noTxSeparatePool);
                    }
                    if (CommonXaPool.Tag.forName((String)reader.getLocalName()) != CommonXaPool.Tag.UNKNOWN) break;
                    throw new ParserException("unexpected end tag" + reader.getLocalName());
                }
                case 1: {
                    switch (CommonXaPool.Tag.forName((String)reader.getLocalName())) {
                        case MAXPOOLSIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case INTERLEAVING: {
                            interleaving = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case ISSAMERMOVERRIDEVALUE: {
                            isSameRmOverrideValue = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            noTxSeparatePool = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PAD_XID: {
                            padXid = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            wrapXaDataSource = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            useStrictMin = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("Unexpected element:" + reader.getLocalName());
                }
            }
        }
        throw new ParserException("Reached end of xml document unexpectedly");
    }

    private String getSubstitutionValue(String input) throws XMLStreamException {
        if (input == null || input.trim().equals("")) {
            return input;
        }
        while (input.indexOf("${") != -1) {
            int from = input.indexOf("${");
            int to = input.indexOf("}");
            int dv = input.indexOf(":", from + 2);
            if (dv != -1 && dv > to) {
                dv = -1;
            }
            String systemProperty = "";
            String defaultValue = "";
            String s = input.substring(from + 2, to);
            if (dv == -1) {
                systemProperty = "/".equals(s) ? File.separator : (":".equals(s) ? File.pathSeparator : SecurityActions.getSystemProperty(s));
            } else {
                s = input.substring(from + 2, dv);
                systemProperty = SecurityActions.getSystemProperty(s);
                defaultValue = input.substring(dv + 1, to);
            }
            String prefix = "";
            String postfix = "";
            if (from != 0) {
                prefix = input.substring(0, from);
            }
            if (to + 1 < input.length() - 1) {
                postfix = input.substring(to + 1);
            }
            if (systemProperty != null && !systemProperty.trim().equals("")) {
                input = prefix + systemProperty + postfix;
                continue;
            }
            if (defaultValue != null && !defaultValue.trim().equals("")) {
                input = prefix + defaultValue + postfix;
                continue;
            }
            input = prefix + postfix;
            log.debugf("System property %s not set", (Object)s);
        }
        return input;
    }

    private static class SecurityActions {
        private SecurityActions() {
        }

        static String getSystemProperty(final String name) {
            if (System.getSecurityManager() == null) {
                return System.getProperty(name);
            }
            return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(name);
                }
            });
        }
    }
}

