/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.marshalling.cloner.ClassCloner;
import org.jboss.marshalling.cloner.ClassLoaderClassCloner;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.cloner.ObjectClonerFactory;
import org.jboss.marshalling.cloner.ObjectCloners;

public final class InVMRemoteInterceptor
implements Interceptor {
    private static final PrivilegedAction<ClassLoader> GET_CLASS_LOADER_ACTION = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private final ClonerConfiguration configuration = new ClonerConfiguration();

    public InVMRemoteInterceptor(ClassLoader targetClassLoader) {
        this.configuration.setClassCloner((ClassCloner)new ClassLoaderClassCloner(targetClassLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processInvocation(InterceptorContext context) throws Exception {
        Object[] parameters = context.getParameters();
        ObjectClonerFactory clonerFactory = ObjectCloners.getSerializingObjectClonerFactory();
        ObjectCloner cloner = clonerFactory.createCloner(this.configuration);
        int len = parameters.length;
        Object[] newParameters = new Object[len];
        for (int i = 0; i < len; ++i) {
            newParameters[i] = cloner.clone(parameters[i]);
        }
        context.setParameters(newParameters);
        try {
            Object result = context.proceed();
            if (result == null) {
                Object var8_9 = null;
                return var8_9;
            }
            ClonerConfiguration copyBackConfiguration = new ClonerConfiguration();
            copyBackConfiguration.setClassCloner((ClassCloner)new ClassLoaderClassCloner(this.getContextClassLoader()));
            Object object = clonerFactory.createCloner(copyBackConfiguration).clone(result);
            return object;
        }
        finally {
            context.setParameters(parameters);
        }
    }

    private ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(GET_CLASS_LOADER_ACTION);
        }
        return Thread.currentThread().getContextClassLoader();
    }
}

