/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InvocationMessages;

public final class InterceptorContext {
    private static final ListIterator<Interceptor> EMPTY = Collections.emptyList().listIterator();
    private Object target;
    private Method method;
    private Object[] parameters;
    private Map<String, Object> contextData;
    private Object timer;
    private ListIterator<Interceptor> interceptorIterator = EMPTY;
    private final Map<Class<?>, Object> privateData = new IdentityHashMap();
    private final InvocationContext invocationContext = new Invocation();

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public void setContextData(Map<String, Object> contextData) {
        this.contextData = contextData;
    }

    public Object getTimer() {
        return this.timer;
    }

    public void setTimer(Object timer) {
        this.timer = timer;
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    public <T> T getPrivateData(Class<T> type) {
        return type.cast(this.privateData.get(type));
    }

    public <T> T putPrivateData(Class<T> type, T value) {
        if (value == null) {
            return type.cast(this.privateData.remove(type));
        }
        return type.cast(this.privateData.put(type, type.cast(value)));
    }

    public ListIterator<Interceptor> getInterceptorIterator() {
        return this.interceptorIterator;
    }

    public void setInterceptorIterator(ListIterator<Interceptor> interceptorIterator) {
        if (interceptorIterator == null) {
            throw new IllegalArgumentException("interceptorIterator is null");
        }
        this.interceptorIterator = interceptorIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed() throws Exception {
        ListIterator<Interceptor> iterator = this.interceptorIterator;
        if (iterator.hasNext()) {
            Interceptor next = iterator.next();
            try {
                Object object = next.processInvocation(this);
                return object;
            }
            finally {
                if (iterator.hasPrevious()) {
                    iterator.previous();
                }
            }
        }
        throw InvocationMessages.msg.cannotProceed();
    }

    static /* synthetic */ Object[] access$302(InterceptorContext x0, Object[] x1) {
        x0.parameters = x1;
        return x1;
    }

    private class Invocation
    implements InvocationContext {
        private Invocation() {
        }

        public Object getTarget() {
            return InterceptorContext.this.target;
        }

        public Method getMethod() {
            return InterceptorContext.this.method;
        }

        public Object[] getParameters() {
            return InterceptorContext.this.parameters;
        }

        public void setParameters(Object[] params) {
            InterceptorContext.access$302(InterceptorContext.this, params);
        }

        public Map<String, Object> getContextData() {
            return InterceptorContext.this.contextData;
        }

        public Object getTimer() {
            return InterceptorContext.this.timer;
        }

        public Object proceed() throws Exception {
            return InterceptorContext.this.proceed();
        }
    }
}

