/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.interceptor.InvocationContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.InvocationMessages;

public final class MethodInterceptor
implements Interceptor {
    private final Object interceptorInstance;
    private final Method method;

    public MethodInterceptor(Object interceptorInstance, Method method) {
        if (interceptorInstance == null) {
            throw InvocationMessages.msg.nullParameter("interceptorInstance");
        }
        if (method == null) {
            throw InvocationMessages.msg.nullParameter("method");
        }
        this.method = method;
        this.interceptorInstance = interceptorInstance;
        this.checkMethodType(interceptorInstance);
    }

    @Override
    public Object processInvocation(InterceptorContext context) throws Exception {
        try {
            return this.method.invoke(this.interceptorInstance, context.getInvocationContext());
        }
        catch (IllegalAccessException e) {
            IllegalAccessError n = new IllegalAccessError(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
        catch (InvocationTargetException e) {
            throw Interceptors.rethrow(e.getCause());
        }
    }

    private void checkMethodType(Object interceptorInstance) {
        Method method = this.method;
        if (!method.getDeclaringClass().isInstance(interceptorInstance)) {
            throw InvocationMessages.msg.wrongInterceptorType();
        }
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw InvocationMessages.msg.targetIsStatic();
        }
        if (!Modifier.isPublic(modifiers) && !method.isAccessible()) {
            throw InvocationMessages.msg.interceptorInaccessible();
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw InvocationMessages.msg.interceptorTargetOneParam();
        }
        if (!parameterTypes[0].isAssignableFrom(InvocationContext.class)) {
            throw InvocationMessages.msg.interceptorTargetAssignableFrom(InvocationContext.class);
        }
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE && !Object.class.isAssignableFrom(returnType)) {
            throw InvocationMessages.msg.interceptorReturnObject();
        }
    }
}

