/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.InvalidClassException;
import java.lang.reflect.Proxy;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

public final class ModularClassResolver
implements ClassResolver {
    private final ModuleLoader moduleLoader;

    private ModularClassResolver() {
        this.moduleLoader = Module.getDefaultModuleLoader();
    }

    private ModularClassResolver(ModuleLoader moduleLoader) {
        this.moduleLoader = moduleLoader;
    }

    public static ModularClassResolver getInstance() {
        return new ModularClassResolver();
    }

    public static ModularClassResolver getInstance(ModuleLoader moduleLoader) {
        return new ModularClassResolver(moduleLoader);
    }

    @Override
    public void annotateClass(Marshaller marshaller, Class<?> clazz) throws IOException {
        Module module = Module.forClass(clazz);
        if (module == null) {
            throw new InvalidClassException(clazz.getName(), "Class is not present in any module");
        }
        ModuleIdentifier identifier = module.getIdentifier();
        marshaller.writeObject(identifier.getName());
        marshaller.writeObject(identifier.getSlot());
    }

    @Override
    public void annotateProxyClass(Marshaller marshaller, Class<?> proxyClass) throws IOException {
        Module module = Module.forClass(proxyClass);
        if (module == null) {
            throw new InvalidClassException(proxyClass.getName(), "Class is not present in any module");
        }
        ModuleIdentifier identifier = module.getIdentifier();
        marshaller.writeObject(identifier.getName());
        marshaller.writeObject(identifier.getSlot());
    }

    @Override
    public String getClassName(Class<?> clazz) throws IOException {
        return clazz.getName();
    }

    @Override
    public String[] getProxyInterfaces(Class<?> proxyClass) throws IOException {
        Class<?>[] interfaces = proxyClass.getInterfaces();
        String[] names = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            names[i] = this.getClassName(interfaces[i]);
        }
        return names;
    }

    @Override
    public Class<?> resolveClass(Unmarshaller unmarshaller, String className, long serialVersionUID) throws IOException, ClassNotFoundException {
        ModuleIdentifier identifier = ModuleIdentifier.create((String)((String)unmarshaller.readObject()), (String)((String)unmarshaller.readObject()));
        try {
            return Class.forName(className, false, (ClassLoader)this.moduleLoader.loadModule(identifier).getClassLoader());
        }
        catch (ModuleLoadException e) {
            InvalidClassException ce = new InvalidClassException(className, "Module load failed");
            ce.initCause(e);
            throw ce;
        }
    }

    @Override
    public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] names) throws IOException, ClassNotFoundException {
        Module module;
        ModuleIdentifier identifier = ModuleIdentifier.create((String)((String)unmarshaller.readObject()), (String)((String)unmarshaller.readObject()));
        try {
            module = this.moduleLoader.loadModule(identifier);
        }
        catch (ModuleLoadException e) {
            InvalidClassException ce = new InvalidClassException("Module load failed");
            ce.initCause(e);
            throw ce;
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        int len = names.length;
        Class[] interfaces = new Class[len];
        for (int i = 0; i < len; ++i) {
            interfaces[i] = Class.forName(names[i], false, (ClassLoader)classLoader);
        }
        return Proxy.getProxyClass((ClassLoader)classLoader, interfaces);
    }
}

