/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.jboss.as.jpa.container.EntityManagerMetadata;
import org.jboss.as.jpa.container.SFSBXPCMap;
import org.jboss.as.jpa.spi.SFSBContextHandle;

public class SFSBCallStack {
    private static ThreadLocal<ArrayList<SFSBContextHandle>> SFSBInvocationStack = new ThreadLocal<ArrayList<SFSBContextHandle>>(){

        @Override
        protected synchronized ArrayList<SFSBContextHandle> initialValue() {
            return new ArrayList<SFSBContextHandle>();
        }
    };

    public EntityManager findPersistenceContext(String puName) {
        for (SFSBContextHandle handle : this.currentSFSBCallStack()) {
            List<EntityManager> xpcs = SFSBXPCMap.getINSTANCE().getXPC(handle);
            for (EntityManager xpc : xpcs) {
                if (!((EntityManagerMetadata)xpc.unwrap(EntityManagerMetadata.class)).getPuName().equals(puName)) continue;
                return xpc;
            }
        }
        return null;
    }

    public ArrayList<SFSBContextHandle> currentSFSBCallStack() {
        return SFSBInvocationStack.get();
    }

    public void pushCall(SFSBContextHandle beanContextHandle) {
        this.currentSFSBCallStack().add(beanContextHandle);
    }

    public SFSBContextHandle popCall() {
        ArrayList<SFSBContextHandle> stack = this.currentSFSBCallStack();
        SFSBContextHandle result = stack.remove(stack.size() - 1);
        stack.trimToSize();
        return result;
    }
}

