/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.spi.SFSBContextHandle;

public class SFSBXPCMap {
    private static final SFSBXPCMap INSTANCE = new SFSBXPCMap();
    private ConcurrentHashMap<SFSBContextHandle, List<EntityManager>> contextToXPCMap = new ConcurrentHashMap();
    private ConcurrentHashMap<EntityManager, List<SFSBContextHandle>> XPCToContextMap = new ConcurrentHashMap();

    public static SFSBXPCMap getINSTANCE() {
        return INSTANCE;
    }

    public List<EntityManager> getXPC(SFSBContextHandle beanContextHandle) {
        return this.contextToXPCMap.get(beanContextHandle);
    }

    public List<SFSBContextHandle> getSFSB(EntityManager entityManager) {
        return this.XPCToContextMap.get(entityManager);
    }

    public void register(SFSBContextHandle beanContextHandle, EntityManager entityManager) {
        if (!(entityManager instanceof AbstractEntityManager)) {
            throw new RuntimeException("internal error, XPC needs to be a AbstractEntityManager so that we can get metadata");
        }
        List<EntityManager> xpcList = Collections.synchronizedList(new ArrayList());
        xpcList.add(entityManager);
        xpcList = this.contextToXPCMap.putIfAbsent(beanContextHandle, xpcList);
        if (null != xpcList) {
            xpcList.add(entityManager);
        }
        List<SFSBContextHandle> sfsbList = Collections.synchronizedList(new ArrayList());
        sfsbList.add(beanContextHandle);
        sfsbList = this.XPCToContextMap.putIfAbsent(entityManager, sfsbList);
        if (null != sfsbList) {
            sfsbList.add(beanContextHandle);
        }
    }

    public List<EntityManager> remove(SFSBContextHandle bean) {
        List result = null;
        List<EntityManager> xpcList = this.contextToXPCMap.remove(bean);
        if (xpcList != null) {
            for (EntityManager xpc : xpcList) {
                List<SFSBContextHandle> sfsbList = this.XPCToContextMap.get(xpc);
                if (sfsbList == null) continue;
                ArrayList<SFSBContextHandle> removed = new ArrayList<SFSBContextHandle>();
                for (SFSBContextHandle beanContextHandle : sfsbList) {
                    if (beanContextHandle != bean && beanContextHandle.getBeanContextHandle() != null) continue;
                    removed.add(beanContextHandle);
                }
                sfsbList.removeAll(removed);
                if (sfsbList.size() != 0) continue;
                result.add(xpc);
            }
        }
        return result;
    }
}

