/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.container.EntityManagerUtil;
import org.jboss.as.jpa.transaction.TransactionUtil;

public class TransactionScopedEntityManager
extends AbstractEntityManager {
    private String puScopedName;
    private Map properties;
    EntityManagerFactory emf;

    public TransactionScopedEntityManager(String puScopedName, Map properties, EntityManagerFactory emf) {
        this.puScopedName = puScopedName;
        this.properties = properties;
        this.emf = emf;
        this.setMetadata(puScopedName, false);
    }

    @Override
    protected EntityManager getEntityManager() {
        EntityManager result = null;
        result = TransactionUtil.getInstance().isInTx() ? TransactionUtil.getInstance().getTransactionScopedEntityManager(this.emf, this.puScopedName, this.properties) : EntityManagerUtil.createEntityManager(this.emf, this.properties);
        this.setMetadata(this.puScopedName, false);
        return result;
    }

    @Override
    public void close() {
        throw new IllegalStateException("Container managed entity manager can only be closed by the container (auto-cleared at tx/invocation end and closed when owning component is closed.)");
    }

    protected void transactionEnded() {
        this.close_internal();
    }

    protected void invocationEnded() {
        this.close_internal();
    }

    private void close_internal() {
    }
}

