/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.List;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.ee.component.ServiceBindingSourceDescription;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.service.PersistenceContextInjectorService;
import org.jboss.as.jpa.service.PersistenceUnitInjectorService;
import org.jboss.as.jpa.service.PersistenceUnitService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class JPAAnnotationParseProcessor
implements DeploymentUnitProcessor {
    private static final DotName PERSISTENCE_CONTEXT_ANNOTATION_NAME = DotName.createSimple((String)PersistenceContext.class.getName());
    private static final DotName PERSISTENCE_UNIT_ANNOTATION_NAME = DotName.createSimple((String)PersistenceUnit.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String applicationName = deploymentUnit.getParent() == null ? deploymentUnit.getName() : deploymentUnit.getParent().getName();
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            return;
        }
        this.addBindings(deploymentUnit, PERSISTENCE_CONTEXT_ANNOTATION_NAME, compositeIndex, moduleDescription, applicationName, phaseContext);
        this.addBindings(deploymentUnit, PERSISTENCE_UNIT_ANNOTATION_NAME, compositeIndex, moduleDescription, applicationName, phaseContext);
    }

    private void addBindings(DeploymentUnit deploymentUnit, DotName annotationName, CompositeIndex compositeIndex, EEModuleDescription moduleDescription, String applicationName, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List instances = compositeIndex.getAnnotations(annotationName);
        if (instances != null) {
            for (AnnotationInstance instance : instances) {
                BindingDescription binding = this.getResourceConfiguration(deploymentUnit, instance, phaseContext);
                String componentName = this.getComponentName(instance);
                AbstractComponentDescription componentDescription = moduleDescription.getComponentByClassName(componentName);
                if (null == componentDescription) continue;
                componentDescription.getBindings().add(binding);
            }
        }
    }

    private String getComponentName(AnnotationInstance annotation) {
        String name;
        AnnotationTarget annotationTarget = annotation.target();
        if (annotationTarget instanceof FieldInfo) {
            name = ((FieldInfo)annotationTarget).declaringClass().name().toString();
        } else if (annotationTarget instanceof MethodInfo) {
            name = ((MethodInfo)annotationTarget).declaringClass().name().toString();
        } else if (annotationTarget instanceof ClassInfo) {
            name = ((ClassInfo)annotationTarget).name().toString();
        } else {
            throw new RuntimeException("unexpected error: AnnotationTarget class of type (" + annotationTarget.getClass().getName() + ") is not handled.");
        }
        return name;
    }

    public void undeploy(DeploymentUnit context) {
    }

    private BindingDescription getResourceConfiguration(DeploymentUnit deploymentUnit, AnnotationInstance annotation, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        AnnotationTarget annotationTarget = annotation.target();
        BindingDescription resourceConfiguration = annotationTarget instanceof FieldInfo ? this.processFieldResource(deploymentUnit, annotation, (FieldInfo)FieldInfo.class.cast(annotationTarget), phaseContext) : (annotationTarget instanceof MethodInfo ? this.processMethodResource(deploymentUnit, annotation, (MethodInfo)MethodInfo.class.cast(annotationTarget), phaseContext) : (annotationTarget instanceof ClassInfo ? this.processClassResource(deploymentUnit, annotation, (ClassInfo)ClassInfo.class.cast(annotationTarget), phaseContext) : null));
        return resourceConfiguration;
    }

    private BindingDescription processFieldResource(DeploymentUnit deploymentUnit, AnnotationInstance annotation, FieldInfo fieldInfo, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String fieldName = fieldInfo.name();
        AnnotationValue declaredNameValue = annotation.value("name");
        String declaredName = declaredNameValue != null ? declaredNameValue.asString() : null;
        String localContextName = declaredName == null || declaredName.isEmpty() ? "java:comp/env/persistence/" + fieldName : declaredName;
        DotName declaredType = fieldInfo.type().name();
        DotName injectionType = declaredType == null || declaredType.toString().equals(Object.class.getName()) ? fieldInfo.type().name() : declaredType;
        BindingDescription bindingDescription = new BindingDescription();
        bindingDescription.setDependency(true);
        bindingDescription.setBindingName(localContextName);
        String injectionTypeName = injectionType.toString();
        bindingDescription.setBindingType(injectionTypeName);
        ServiceName injectorName = this.getInjectorServiceName(deploymentUnit, annotation, phaseContext);
        bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(injectorName));
        InjectionTargetDescription targetDescription = new InjectionTargetDescription();
        targetDescription.setName(fieldName);
        targetDescription.setClassName(fieldInfo.declaringClass().name().toString());
        targetDescription.setType(InjectionTargetDescription.Type.FIELD);
        targetDescription.setValueClassName(injectionTypeName);
        bindingDescription.getInjectionTargetDescriptions().add(targetDescription);
        return bindingDescription;
    }

    private BindingDescription processMethodResource(DeploymentUnit deploymentUnit, AnnotationInstance annotation, MethodInfo methodInfo, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw new IllegalArgumentException("@PersistenceContext injection target is invalid.  Only setter methods are allowed: " + methodInfo);
        }
        String contextNameSuffix = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        AnnotationValue declaredNameValue = annotation.value("name");
        String declaredName = declaredNameValue != null ? declaredNameValue.asString() : null;
        String localContextName = declaredName == null || declaredName.isEmpty() ? methodInfo.declaringClass().name().toString() + "/" + contextNameSuffix : declaredName;
        DotName declaredType = methodInfo.returnType().name();
        DotName injectionType = declaredType == null || declaredType.toString().equals(Object.class.getName()) ? methodInfo.returnType().name() : declaredType;
        BindingDescription bindingDescription = new BindingDescription();
        bindingDescription.setDependency(true);
        bindingDescription.setBindingName(localContextName);
        String injectionTypeName = injectionType.toString();
        bindingDescription.setBindingType(injectionTypeName);
        ServiceName injectorName = this.getInjectorServiceName(deploymentUnit, annotation, phaseContext);
        bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(injectorName));
        InjectionTargetDescription targetDescription = new InjectionTargetDescription();
        targetDescription.setName(methodName);
        targetDescription.setClassName(methodInfo.declaringClass().name().toString());
        targetDescription.setType(InjectionTargetDescription.Type.METHOD);
        targetDescription.setValueClassName(injectionTypeName);
        bindingDescription.getInjectionTargetDescriptions().add(targetDescription);
        return bindingDescription;
    }

    private BindingDescription processClassResource(DeploymentUnit deploymentUnit, AnnotationInstance annotation, ClassInfo classInfo, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        AnnotationValue nameValue = annotation.value("name");
        if (nameValue == null || nameValue.asString().isEmpty()) {
            throw new IllegalArgumentException("Class level @PersistenceContext annotations must provide a name.");
        }
        String name = nameValue.asString();
        String type = classInfo.name().toString();
        BindingDescription bindingDescription = new BindingDescription();
        bindingDescription.setDependency(true);
        bindingDescription.setBindingName(name);
        bindingDescription.setBindingType(type);
        ServiceName injectorName = this.getInjectorServiceName(deploymentUnit, annotation, phaseContext);
        bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(injectorName));
        return bindingDescription;
    }

    private ServiceName getInjectorServiceName(DeploymentUnit deploymentUnit, AnnotationInstance annotation, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String name = annotation.target().toString();
        String scopedPuName = this.getScopedPuName(deploymentUnit, annotation);
        ServiceName puServiceName = this.getPuServiceName(scopedPuName);
        ServiceName injectorName = ServiceName.of((ServiceName)puServiceName, (String[])new String[]{name});
        if (this.isPersistenceContext(annotation)) {
            phaseContext.getServiceTarget().addService(injectorName, (Service)new PersistenceContextInjectorService(annotation, puServiceName, deploymentUnit, scopedPuName)).addDependency(puServiceName).setInitialMode(ServiceController.Mode.ACTIVE).install();
        } else {
            phaseContext.getServiceTarget().addService(injectorName, (Service)new PersistenceUnitInjectorService(annotation, puServiceName, deploymentUnit, scopedPuName)).addDependency(puServiceName).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        return injectorName;
    }

    private boolean isPersistenceContext(AnnotationInstance annotation) {
        return annotation.name().local().equals("PersistenceContext");
    }

    private String getScopedPuName(DeploymentUnit deploymentUnit, AnnotationInstance annotation) throws DeploymentUnitProcessingException {
        String scopedPuName;
        AnnotationValue puName = annotation.value("unitName");
        String searchName = null;
        if (puName != null) {
            searchName = puName.asString();
        }
        if (null == (scopedPuName = PersistenceUnitSearch.resolvePersistenceUnitSupplier(deploymentUnit, searchName))) {
            throw new DeploymentUnitProcessingException("Can't find a deployment unit named " + puName.asString() + " at " + deploymentUnit);
        }
        return scopedPuName;
    }

    private ServiceName getPuServiceName(String scopedPuName) throws DeploymentUnitProcessingException {
        return PersistenceUnitService.getPUServiceName(scopedPuName);
    }
}

